/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import org.miv.pherd.Particle;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Anchor;

public abstract class CellSpace {
    protected Anchor lo;
    protected Anchor hi;
    protected double diag;

    public CellSpace(Anchor lo, Anchor hi) {
        this.lo = lo;
        this.hi = hi;
        this.diag = lo.distance(hi);
    }

    public Anchor getLoAnchor() {
        return this.lo;
    }

    public Anchor getHiAnchor() {
        return this.hi;
    }

    public abstract int getDivisions();

    public abstract CellSpace newSubCellSpace(int var1);

    public boolean contains(Particle particle) {
        Point3 ppos = particle.getPosition();
        return this.contains(ppos.x, ppos.y, ppos.z);
    }

    public boolean contains(double x, double y, double z) {
        if (x < this.lo.x || x >= this.hi.x) {
            return false;
        }
        if (y < this.lo.y || y >= this.hi.y) {
            return false;
        }
        return !(z < this.lo.z) && !(z >= this.hi.z);
    }

    public boolean contains2(double x, double y, double z) {
        System.err.printf("contains (%f,%f,%f)  %s %s%n", x, y, z, this.lo, this.hi);
        if (x < this.lo.x || x >= this.hi.x) {
            return false;
        }
        if (y < this.lo.y || y >= this.hi.y) {
            return false;
        }
        return !(z < this.lo.z) && !(z >= this.hi.z);
    }

    public double getSize() {
        return this.diag;
    }

    public void resize(Point3 min, Point3 max) {
        this.lo = new Anchor(min.x, min.y, min.z);
        this.hi = new Anchor(max.x, max.y, max.z);
        this.diag = this.lo.distance(this.hi);
    }
}

