/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.contextmap.generator.model;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.contextmapper.contextmap.generator.model.BoundedContextType;
import org.contextmapper.contextmap.generator.model.exception.BoundedContextIsNotATeamException;
import org.contextmapper.contextmap.generator.model.exception.TeamCannotImplementTeamException;

public class BoundedContext {
    private String name;
    private BoundedContextType type;
    private List<BoundedContext> realizedBoundedContexts;

    public BoundedContext(String name) {
        this.name = name;
        this.type = BoundedContextType.GENERIC;
        this.realizedBoundedContexts = new LinkedList<BoundedContext>();
    }

    public BoundedContext(String name, BoundedContextType type) {
        this(name);
        this.type = type;
    }

    public BoundedContext withType(BoundedContextType type) {
        this.type = type;
        return this;
    }

    public BoundedContext realizing(BoundedContext genericContext) {
        if (this.type != BoundedContextType.TEAM) {
            throw new BoundedContextIsNotATeamException(this.name);
        }
        if (genericContext.getType() == BoundedContextType.TEAM) {
            throw new TeamCannotImplementTeamException(genericContext.getName());
        }
        this.realizedBoundedContexts.add(genericContext);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BoundedContextType getType() {
        return this.type;
    }

    public List<BoundedContext> getRealizedBoundedContexts() {
        if (this.type != BoundedContextType.TEAM) {
            return new LinkedList<BoundedContext>();
        }
        return this.realizedBoundedContexts.stream().filter(bc -> bc.getType() != BoundedContextType.TEAM).collect(Collectors.toList());
    }

    public boolean equals(Object object) {
        if (!(object instanceof BoundedContext)) {
            return false;
        }
        BoundedContext bc = (BoundedContext)object;
        return new EqualsBuilder().append((Object)this.name, (Object)bc.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).hashCode();
    }
}

