/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.websocket;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.support.websocket.CallerHackConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerHackFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CallerHackFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                HttpSession session = httpServletRequest.getSession(true);
                String xff = httpServletRequest.getHeader("X-Forwarded-For");
                session.setAttribute(CallerHackConfigurator.WEB_SOCKET_CALLER_INFO, (Object)new HackedCaller(xff == null ? httpServletRequest.getRemoteAddr() : xff.split(",")[0].trim(), httpServletRequest.getHeader("User-Agent")));
            }
        }
        catch (Throwable th) {
            log.warn(th.getLocalizedMessage(), th);
        }
        finally {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static class HackedCaller
    implements Caller,
    Serializable {
        private final String ip;
        private final String userAgent;

        private HackedCaller(String ip, String userAgent) {
            this.ip = ip;
            this.userAgent = userAgent;
        }

        public String getAddress() {
            return this.ip;
        }

        public String getClientProvider() {
            return this.userAgent;
        }
    }
}

