/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.support.websocket;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import org.coodex.concrete.common.Caller;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ErrorCodes;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServerSideContext;
import org.coodex.concrete.common.ThrowableMapperFacade;
import org.coodex.concrete.message.ServerSideMessage;
import org.coodex.concrete.own.OwnServiceProvider;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.concrete.own.ResponsePackage;
import org.coodex.concrete.support.websocket.CallerHackConfigurator;
import org.coodex.concrete.support.websocket.WebSocketServiceContext;
import org.coodex.concrete.websocket.ConcreteWebSocketEndPoint;
import org.coodex.concrete.websocket.InvalidRequest;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketServerHandle
extends OwnServiceProvider
implements ConcreteWebSocketEndPoint {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerHandle.class);
    private static final Map<Session, String> peers = Collections.synchronizedMap(new HashMap());
    private static final OwnServiceProvider.OwnModuleBuilder OWN_MODULE_BUILDER = WebSocketModule::new;

    protected OwnServiceProvider.OwnModuleBuilder getModuleBuilder() {
        return OWN_MODULE_BUILDER;
    }

    WebSocketServerHandle() {
        this.registerPackage(new String[]{ErrorCodes.class.getPackage().getName()});
    }

    private static void $sendText(String text, Session session, AtomicInteger retry) {
        AtomicInteger toRetry;
        AtomicInteger atomicInteger = toRetry = retry == null ? new AtomicInteger(0) : retry;
        if (toRetry.get() >= 5) {
            log.warn("send text failed after retry 5 times. sessionId: {}, text: {}", (Object)session.getId(), (Object)text);
            return;
        }
        try {
            session.getBasicRemote().sendText(text);
        }
        catch (IOException | IllegalStateException e) {
            log.warn("send text failed. session: {}", (Object)session.getId(), (Object)e);
            ConcreteHelper.getScheduler((String)"websocket.retry").schedule(() -> {
                toRetry.incrementAndGet();
                WebSocketServerHandle.$sendText(text, session, toRetry);
            }, 20L, TimeUnit.MILLISECONDS);
        }
    }

    private static <T> void sendMessage(ServerSideMessage<T> message, String tokenId) {
        for (Session session : peers.keySet()) {
            if (!tokenId.equals(peers.get(session))) continue;
            WebSocketServerHandle.$sendText(JSONSerializerFactory.getInstance().toJson(WebSocketServerHandle.buildPackage(message)), session, null);
            break;
        }
    }

    private static <T> ResponsePackage<T> buildPackage(ServerSideMessage<T> message) {
        ResponsePackage responsePackage = new ResponsePackage();
        HashMap<String, String> subjoin = new HashMap<String, String>();
        subjoin.put("broadcast", "true");
        subjoin.put("hostId", message.getHost());
        subjoin.put("subject", message.getSubject());
        responsePackage.setSubjoin(subjoin);
        responsePackage.setContent(message.getBody());
        responsePackage.setMsgId(message.getId());
        return responsePackage;
    }

    public void onOpen(Session peer) {
        if (!peers.containsKey(peer)) {
            peers.put(peer, Common.getUUIDStr());
        }
        peer.setMaxIdleTimeout(0L);
        log.debug("session opened: {}, concrete token id: {}, total sessions: {}", new Object[]{peer, peers.get(peer), peers.size()});
    }

    public void onClose(Session peer) {
        peers.remove(peer);
        log.debug("session closed: {}, total sessions: {}", (Object)peer, (Object)peers.size());
    }

    private void broadcastText(String text, Session session) {
        log.debug("broadcast, async send to {}:\n{}", (Object)session.getId(), (Object)text);
        this.$sendText(text, session);
    }

    private void $sendText(String text, Session session) {
        WebSocketServerHandle.$sendText(text, session, null);
    }

    private void sendText(String text, Session session) {
        log.debug("async send to {}:\n{}", (Object)session.getId(), (Object)text);
        this.$sendText(text, session);
    }

    private void sendError(String msgId, Throwable exception, Session session) {
        ResponsePackage responsePackage = new ResponsePackage();
        responsePackage.setOk(false);
        responsePackage.setMsgId(msgId);
        responsePackage.setContent((Object)ThrowableMapperFacade.toErrorInfo((Throwable)exception));
        this.sendText(JSONSerializerFactory.getInstance().toJson((Object)responsePackage), session);
    }

    private <T> ResponsePackage buildPackage(String subject, T content, Map<String, String> subjoin) {
        if (subjoin == null) {
            subjoin = new HashMap<String, String>();
        }
        subjoin.put("broadcast", "true");
        subjoin.put("hostId", this.getHostId());
        subjoin.put("subject", subject);
        ResponsePackage responsePackage = new ResponsePackage();
        responsePackage.setSubjoin(new HashMap<String, String>(subjoin));
        if (content != null) {
            responsePackage.setContent(content);
        }
        return responsePackage;
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.debug("message from {}:\n {}", (Object)session.getId(), (Object)message);
        RequestPackage<Object> requestPackage = this.analysisRequest(message, session);
        if (requestPackage == null) {
            return;
        }
        try {
            this.invokeService(requestPackage, session);
        }
        catch (Throwable th) {
            this.sendError(requestPackage.getMsgId(), th, session);
        }
    }

    private void invokeService(RequestPackage<Object> requestPackage, final Session session) {
        Caller caller = (Caller)session.getUserProperties().get(CallerHackConfigurator.WEB_SOCKET_CALLER_INFO);
        OwnServiceProvider.DefaultResponseVisitor responseVisitor = new OwnServiceProvider.DefaultResponseVisitor(){

            public void visit(String json) {
                WebSocketServerHandle.this.sendText(json, session);
            }
        };
        OwnServiceProvider.ErrorVisitor errorVisitor = (msgId, th) -> this.sendError(msgId, th, session);
        OwnServiceProvider.ServerSideMessageVisitor serverSideMessageVisitor = WebSocketServerHandle::sendMessage;
        OwnServiceProvider.TBMNewTokenVisitor newTokenVisitor = tokenId -> peers.put(session, tokenId);
        this.invokeService(requestPackage, caller, (OwnServiceProvider.ResponseVisitor)responseVisitor, errorVisitor, serverSideMessageVisitor, newTokenVisitor);
    }

    protected ServerSideContext getServerSideContext(RequestPackage<Object> requestPackage, String tokenId, Caller caller) {
        return new WebSocketServiceContext(tokenId, this.getSubjoin(requestPackage.getSubjoin()), caller, null);
    }

    protected String getModuleName() {
        return "websocket";
    }

    private RequestPackage<Object> analysisRequest(String message, Session session) {
        try {
            return (RequestPackage)JSONSerializerFactory.getInstance().parse(message, new GenericTypeHelper.GenericType<RequestPackage<Object>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.broadcastText(JSONSerializerFactory.getInstance().toJson((Object)this.buildPackage("INVALID_REQUEST", new InvalidRequest(ConcreteHelper.getException((Throwable)throwable), message), null)), session);
            return null;
        }
    }

    private String getHostId() {
        return (String)Config.getValue((String)"websocket.hostId", (Object)Common.getUUIDStr(), (String[])new String[]{ConcreteHelper.getAppSet()});
    }

    public String getNamespace() {
        return "websocket";
    }
}

