/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock;

import java.util.ArrayList;

public enum CharCodeSet {
    BASIC_LATIN(0, 127),
    LATIN_1_SUPPLEMENT(128, 255),
    LATIN_EXTENDED_A(256, 383),
    LATIN_EXTENDED_B(384, 591),
    IPA_EXTENSIONS(592, 687),
    SPACING_MODIFIER_LETTERS(688, 767),
    COMBINING_DIACRITICS_MARKS(768, 879),
    GREEK_AND_COPTIC(880, 1023),
    CYRILLIC(1024, 1279),
    CYRILLIC_SUPPLEMENT(1280, 1327),
    ARMENIAN(1328, 1423),
    HEBREW(1424, 1535),
    ARABIC(1536, 1791),
    SYRIAC(1792, 1871),
    ARABIC_SUPPLEMENT(1872, 1919),
    THAANA(1920, 1983),
    N_KO(1984, 2047),
    SAMARITAN(2048, 2111),
    MANDAIC(2112, 2143),
    SYRIAC_SUPPLEMENT(2144, 2159),
    ARABIC_EXTENDED_A(2208, 2303),
    DEVANAGARI(2304, 2431),
    BENGALI(2432, 2559),
    GURMUKHI(2560, 2687),
    GUJARATI(2688, 2815),
    ORIYA(2816, 2943),
    TAMIL(2944, 3071),
    TELUGU(3072, 3199),
    KANNADA(3200, 3327),
    MALAYALAM(3328, 3455),
    SINHALA(3456, 3583),
    THAI(3584, 3711),
    LAO(3712, 3839),
    TIBETAN(3840, 4095),
    MYANMAR(4096, 4255),
    GEORGIAN(4256, 4351),
    HANGUL_JAMO(4352, 4607),
    ETHIOPIC(4608, 4991),
    ETHIOPIC_SUPPLEMENT(4992, 5023),
    CHEROKEE(5024, 5119),
    UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS(5120, 5759),
    OGHAM(5760, 5791),
    RUNIC(5792, 5887),
    TAGALOG(5888, 5919),
    HANUNOO(5920, 5951),
    BUHID(5952, 5983),
    TAGBANWA(5984, 6015),
    KHMER(6016, 6143),
    MONGOLIAN(6144, 6319),
    UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED(6320, 6399),
    LIMBU(6400, 6479),
    TAI_LE(6480, 6527),
    NEW_TAI_LUE(6528, 6623),
    KHMER_SYMBOLS(6624, 6655),
    BUGINESE(6656, 6687),
    TAI_THAM(6688, 6831),
    COMBINING_DIACRITICAL_MARKS_EXTENDED(6832, 6911),
    BALINESE(6912, 7039),
    SUNDANESE(7040, 7103),
    BATAK(7104, 7167),
    LEPCHA(7168, 7247),
    OL_CHIKI(7248, 7295),
    CYRILLIC_EXTENDED_C(7296, 7311),
    GEORGIAN_EXTENDED(7312, 7359),
    SUDANESE_SUPPLEMENT(7360, 7375),
    VEDIC_EXTENSIONS(7376, 7423),
    PHONETIC_EXTENSIONS(7424, 7551),
    PHONETIC_EXTENSIONS_SUPPLEMENT(7552, 7615),
    COMBINING_DIACRITICS_MARKS_SUPPLEMENT(7616, 7679),
    LATIN_EXTENDED_ADDITIONAL(7680, 7935),
    GREEK_EXTENDED(7936, 8191),
    GENERAL_PUNCTUATION(8192, 8303),
    SUPERSCRIPTS_AND_SUBSCRIPTS(8304, 8351),
    CURRENCY_SYMBOLS(8352, 8399),
    COMBINING_DIACRITICS_MARKS_FOR_SYMBOLS(8400, 8447),
    LETTERLIKE_SYMBOLS(8448, 8527),
    NUMBER_FORMS(8528, 8591),
    ARROWS(8592, 8703),
    MATHEMATICAL_OPERATORS(8704, 8959),
    MISCELLANEOUS_TECHNICAL(8960, 9215),
    CONTROL_PICTURES(9216, 9279),
    OPTICAL_CHARACTER_RECOGNITION(9280, 9311),
    ENCLOSED_ALPHANUMERICS(9312, 9471),
    BOX_DRAWING(9472, 9599),
    BLOCK_ELEMENTS(9600, 9631),
    GEOMETRIC_SHAPES(9632, 9727),
    MISCELLANEOUS_SYMBOLS(9728, 9983),
    DINGBATS(9984, 10175),
    MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A(10176, 10223),
    SUPPLEMENTAL_ARROWS_A(10224, 10239),
    BRAILLE_PATTERNS(10240, 10495),
    SUPPLEMENTAL_ARROWS_B(10496, 10623),
    MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B(10624, 10751),
    SUPPLEMENTAL_MATHEMATICAL_OPERATOR(10752, 11007),
    MISCELLANEOUS_SYMBOLS_AND_ARROWS(11008, 11263),
    GLAGOLITIC(11264, 11359),
    LATIN_EXTENDED_C(11360, 11391),
    COPTIC(11392, 11519),
    GEORGIAN_SUPPLEMENT(11520, 11567),
    TIFINAGH(11568, 11647),
    ETHIOPIC_EXTENDED(11648, 11743),
    CYRILLIC_EXTENDED_A(11744, 11775),
    SUPPLEMENTAL_PUNCTUATION(11776, 11903),
    CJK_RADICALS_SUPPLEMENT(11904, 12031),
    KANGXI_RADICALS(12032, 12255),
    IDEOGRAPHIC_DESCRIPTION_CHARACTERS(12272, 12287),
    CJK_SYMBOLS_AND_PUNCTUATION(12288, 12351),
    HIRAGANA(12352, 12447),
    KATAKANA(12448, 12543),
    BOPOMOFO(12544, 12591),
    HANGUL_COMPATIBILITY_JAMO(12592, 12687),
    KANBUN(12688, 12703),
    BOPOMOFO_EXTENDED(12704, 12735),
    CJK_STROKES(12736, 12783),
    KATAKANA_PHONETIC_EXTENSIONS(12784, 12799),
    ENCLOSED_CJK_LETTERS_AND_MONTHS(12800, 13055),
    CJK_COMPATIBILITY(13056, 13311),
    CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A(13312, 19903),
    YIJING_HEXAGRAMS_SYMBOLS(19904, 19967),
    CJK_UNIFIED_IDEOGRAPHS(19968, 40959),
    YI_SYLLABLES(40960, 42127),
    YI_RADICALS(42128, 42191),
    LISU(42192, 42239),
    VAI(42240, 42559),
    CYRILLIC_EXTENDED_B(42560, 42655),
    BAMUM(42656, 42751),
    MODIFIER_TONE_LETTERS(42752, 42783),
    LATIN_EXTENDED_D(42784, 43007),
    SYLOTI_NAGRI(43008, 43055),
    COMMON_INDIC_NUMBER_FORMS(43056, 43071),
    PHAGS_PA(43072, 43135),
    SAURASHTRA(43136, 43231),
    DEVANAGARI_EXTENDED(43232, 43263),
    KAYAH_LI(43264, 43311),
    REJANG(43312, 43359),
    HANGUL_JAMO_EXTENDED_A(43360, 43391),
    JAVANESE(43392, 43487),
    MYANMAR_EXTENDED_B(43488, 43519),
    CHAM(43520, 43615),
    MYANMAR_EXTENDED_A(43616, 43647),
    TAI_VIET(43648, 43743),
    MEETEI_MAYEK_EXTENSIONS(43744, 43775),
    ETHIOPIC_EXTENDED_A(43776, 43823),
    LATIN_EXTENDED_E(43824, 43887),
    CHEROKEE_SUPPLEMENT(43888, 43967),
    MEETEI_MAYEK(43968, 44031),
    HANGUL_SYLLABLES(44032, 55215),
    HANGUL_JAMO_EXTENDED_B(55216, 55295),
    PRIVATE_USE_AREA(57344, 63743),
    CJK_COMPATIBILITY_IDEOGRAPHS(63744, 64255),
    ALPHABETIC_PRESENTATION_FORMS(64256, 64335),
    ARABIC_PRESENTATION_FORMS_A(64336, 65023),
    VARIATION_SELECTOR(65024, 65039),
    VERTICAL_FORMS(65040, 65055),
    COMBINING_HALF_MARKS(65056, 65071),
    CJK_COMPATIBILITY_FORMS(65072, 65103),
    SMALL_FORM_VARIANTS(65104, 65135),
    ARABIC_PRESENTATION_FORMS_B(65136, 65279),
    HALFWIDTH_AND_FULLWIDTH_FORMS(65280, 65519),
    SPECIALS(65520, 65535),
    LINEAR_B_SYLLABARY(65536, 65663),
    LINEAR_B_IDEOGRAMS(65664, 65791),
    AEGEAN_NUMBERS(65792, 65855),
    ANCIENT_GREEK_NUMBERS(65856, 65935),
    ANCIENT_SYMBOLS(65936, 65999),
    PHAISTOS_DISC(66000, 66047),
    LYCIAN(66176, 66207),
    CARIAN(66208, 66271),
    COPTIC_EPACT_NUMBERS(66272, 66303),
    OLD_ITALIC(66304, 66351),
    GOTHIC(66352, 66383),
    OLD_PERMIC(66384, 66431),
    UGARITIC(66432, 66463),
    OLD_PERSIAN(66464, 66527),
    DESERET(66560, 66639),
    SHAVIAN(66640, 66687),
    OSMANYA(66688, 66735),
    OSAGE(66736, 66815),
    ELBASAN(66816, 66863),
    CAUCASIAN_ALBANIAN(66864, 66927),
    LINEAR_A(67072, 67455),
    CYPRIOT_SYLLABARY(67584, 67647),
    IMPERIAL_ARAMAIC(67648, 67679),
    PALMYRENE(67680, 67711),
    NABATAEAN(67712, 67759),
    HATRAN(67808, 67839),
    PHOENICIAN(67840, 67871),
    LYDIAN(67872, 67903),
    MEROITIC_HIEROGLYPHS(67968, 67999),
    MEROITIC_CURSIVE(68000, 68095),
    KHAROSHTHI(68096, 68191),
    OLD_SOUTH_ARABIAN(68192, 68223),
    OLD_NORTH_ARABIAN(68224, 68255),
    MANICHAEAN(68288, 68351),
    AVESTAN(68352, 68415),
    INSCRIPTIONAL_PARTHIAN(68416, 68447),
    INSCRIPTIONAL_PAHLAVI(68448, 68479),
    PSALTER_PAHLAVI(68480, 68527),
    OLD_TURKIC(68608, 68687),
    HANIFI_ROHINGYA(68864, 68927),
    OLD_HUNGARIAN(68736, 68863),
    RUMI_NUMERAL_SYMBOLS(69216, 69247),
    OLD_SOGDIAN(69376, 69423),
    SOGDIAN(69424, 69487),
    ELYMAIC(69600, 69631),
    BRAHMI(69632, 69759),
    KAITHI(69760, 69839),
    SORA_SOMPENG(69840, 69887),
    CHAKMA(69888, 69967),
    MAHAJANI(69968, 70015),
    SHARADA(70016, 70111),
    SINHALA_ARCHAIC_NUMBERS(70112, 70143),
    KHOJKI(70144, 70223),
    MULTANI(70272, 70319),
    KHUDAWADI(70320, 70399),
    GRANTHA(70400, 70527),
    NEWA(70656, 70783),
    TIRHUTA(70784, 70879),
    SIDDHAM(71040, 71167),
    MODI(71168, 71263),
    MONGOLIAN_SUPPLEMENT(71264, 71295),
    TAKRI(71296, 71375),
    AHOM(71424, 71487),
    DOGRA(71680, 71759),
    WARANG_CITI(71840, 71935),
    NANDINAGARI(72096, 72191),
    ZANABAZAR_SQUARE(72192, 72271),
    SOYOMBO(72272, 72367),
    PAU_CIN_HAU(72384, 72447),
    BHAIKSUKI(72704, 72815),
    MARCHEN(72816, 72895),
    MASARAM_GONDI(72960, 73055),
    GUNJALA_GONDI(73056, 73135),
    MAKASAR(73440, 73471),
    TAMIL_SUPPLEMENT(73664, 73727),
    CUNEIFORM(73728, 74751),
    CUNEIFORM_NUMBERS_AND_PUNCTUATION(74752, 74879),
    EARLY_DYNASTIC_CUNEIFORM(74880, 75087),
    EGYPTIAN_HIEROGLYPHS(77824, 78895),
    EGYPTIAN_HIEROGLYPHS_FORMAT_CONTROLS(78896, 78911),
    ANATOLIAN_HIEROGLYPHS(82944, 83583),
    BAMUM_SUPPLEMENT(92160, 92735),
    MRO(92736, 92783),
    BASSA_VAH(92880, 92927),
    PAHAWH_HMONG(92928, 93071),
    MEDEFAIDRIN(93760, 93855),
    MIAO(93952, 94111),
    IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION(94176, 94207),
    TANGUT(94208, 100351),
    TANGUT_COMPONENTS(100352, 101119),
    KANA_SUPPLEMENT(110592, 110847),
    KANA_EXTENDED_A(110848, 110895),
    SMALL_KANA_EXTENSION(110896, 110959),
    NUSHU(110960, 111359),
    DUPLOYAN(113664, 113823),
    SHORTHAND_FORMAT_CONTROLS(113824, 113839),
    BYZANTINE_MUSICAL_SYMBOLS(118784, 119039),
    MUSICAL_SYMBOLS(119040, 119295),
    ANCIENT_GREEK_MUSICAL_NOTATION(119296, 119375),
    MAYAN_NUMERALS(119520, 119551),
    TAI_XUAN_JING_SYMBOLS(119552, 119647),
    COUNTING_ROD_NUMERALS(119648, 119679),
    MATHEMATICAL_ALPHANUMERIC_SYMBOLS(119808, 120831),
    SUTTON_SIGNWRITING(120832, 121519),
    GLAGOLITIC_SUPPLEMENT(122880, 122927),
    NYIAKENG_PUACHUE_HMONG(123136, 123215),
    WANCHO(123584, 123647),
    MENDE_KIKAKUI(124928, 125151),
    ADLAM(125184, 125279),
    INDIC_SIYAQ_NUMBERS(126064, 126143),
    OTTOMAN_SIYAQ_NUMBERS(126208, 126287),
    ARABIC_MATHEMATICAL_ALPHANUMERIC_SYMBOLS(126464, 126719),
    MAHJONG_TILES(126976, 127023),
    DOMINO_TILES(127024, 127135),
    PLAYING_CARDS(127136, 127231),
    ENCLOSED_ALPHANUMERIC_SUPPLEMENT(127232, 127487),
    ENCLOSED_IDEOGRAPHIC_SUPPLEMENT(127488, 127743),
    MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS(127744, 128511),
    EMOTIONS(128512, 128591),
    ORNAMENTAL_DINGBATS(128592, 128639),
    TRANSPORT_AND_MAP_SYMBOLS(128640, 128767),
    ALCHEMICAL_SYMBOLS(128768, 128895),
    GEOMETRIC_SHAPES_EXTENDED(128896, 129023),
    SUPPLEMENTAL_ARROWS_C(129024, 129279),
    SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS(129280, 129535),
    CHESS_SYMBOLS(129536, 129647),
    SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A(129648, 129791),
    CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B(131072, 173791),
    CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C(173824, 177983),
    CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D(177984, 178207),
    CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E(178208, 183983),
    CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F(183984, 191471),
    CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT(194560, 195103),
    TAGS(917504, 917631),
    VARIATION_SELECTORS_SUPPLEMENT(917760, 917999);

    private static CharCodeSet[] JAVA_CHAR_CODE_SET;
    private int min;
    private int max;
    private int count;
    private boolean bmp;

    private CharCodeSet(int min, int max) {
        this.min = min;
        this.max = max;
        this.count = max - min + 1;
        this.bmp = this.max < 65536;
    }

    public static CharCodeSet[] getBasicMultilingualPlane() {
        if (JAVA_CHAR_CODE_SET == null) {
            ArrayList<CharCodeSet> list = new ArrayList<CharCodeSet>();
            for (CharCodeSet charCodeSet : (CharCodeSet[])CharCodeSet.class.getEnumConstants()) {
                if (!charCodeSet.isBmp()) continue;
                list.add(charCodeSet);
            }
            JAVA_CHAR_CODE_SET = list.toArray(new CharCodeSet[0]);
        }
        return JAVA_CHAR_CODE_SET;
    }

    public boolean isBmp() {
        return this.bmp;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getCount() {
        return this.count;
    }

    static {
        JAVA_CHAR_CODE_SET = null;
    }
}

