/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.mock.ext;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.coodex.mock.Mock;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Mock
public @interface Coordinates {
    public String longitude() default "(-180, 180)";

    public String latitude() default "(-90, 90)";

    public Dimension dimension() default Dimension.LONGITUDE;

    public int digits() default 8;

    public static class Value {
        private double longitude;
        private double latitude;

        public double getLongitude() {
            return this.longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
                return false;
            }
            return Double.compare(this.getLatitude(), other.getLatitude()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Value;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $longitude = Double.doubleToLongBits(this.getLongitude());
            result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
            long $latitude = Double.doubleToLongBits(this.getLatitude());
            result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
            return result;
        }

        public String toString() {
            return "Coordinates.Value(longitude=" + this.getLongitude() + ", latitude=" + this.getLatitude() + ")";
        }
    }

    public static enum Dimension {
        LONGITUDE,
        LATITUDE;

    }
}

