/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.sharedcache;

import java.util.ServiceLoader;
import org.coodex.sharedcache.SharedCacheClient;
import org.coodex.sharedcache.SharedCacheClientFactory;
import org.coodex.sharedcache.SharedCacheClientFactoryProviderNotFoundException;

public class SharedCacheClientManager {
    private static ServiceLoader<SharedCacheClientFactory> factoryProviders;

    private static synchronized void load() {
        if (factoryProviders == null) {
            factoryProviders = ServiceLoader.load(SharedCacheClientFactory.class);
        }
    }

    public static SharedCacheClient getClient(String driverName) {
        if (driverName == null) {
            throw new NullPointerException("distributed cache driverName must not be NULL.");
        }
        SharedCacheClientManager.load();
        for (SharedCacheClientFactory factory : factoryProviders) {
            if (!factory.isAccepted(driverName)) continue;
            return factory.getClientInstance();
        }
        throw new SharedCacheClientFactoryProviderNotFoundException(driverName);
    }
}

