/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe;

import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.State;
import org.coos.javaframe.StateMachine;
import org.coos.javaframe.TraceConstants;
import org.coos.javaframe.messages.AFPropertyMsg;
import org.coos.javaframe.messages.ActorMsg;

/**
 * @author Knut Eilif Husa, Tellu AS
 */
public class ActorDomainCS extends ActorCS {
	public ActorDomainCS(String sn) {
		super(sn);
	}

	// Definition of states
	public State waitCreation = new State("waitCreation", this);
	final long TIMER_ACTOR_REG = 15 * 1000;

	final String TARGET_ACTOR = "targetActor";

	// On exit from the sub state ActorSuspended
	/*
	 * public void outofInnerCompositeState(CompositeState cs, int exNo,
	 * StateMachine curfsm) { //curfsm.startTimer(TIMER_ACTOR_REG,
	 * TIMER_ACTOR_REG_ID); super.outofInnerCompositeState(cs, exNo, curfsm); }
	 */

	public void execTrans(ActorMsg sig, State st, StateMachine curfsm) {
		ActorDomainSM asm = (ActorDomainSM) curfsm;

		if (st == idle) {
			if (sig.equals(START_PLAYING_MSG)) {
				asm.getScheduler().upDateVisibleActors(asm);
				asm.startTimer(TIMER_ACTOR_REG, TIMER_ACTOR_REG_ID);
				// asm.setTraceLevel(TraceConstants.tlError);
				sameState(curfsm);

				return;
			} else if (sig.equals(ROLE_CREATE_MSG)) {
				performExit(curfsm);

				// check if targetActor is set in RoleCreate. If so this message
				// shall be send to
				// the this target actor. Current actor is a ActorDomain acntor,
				// that forward role create
				// messages
				if (sig.getProperty(TARGET_ACTOR) != null) {
					// forward this message to the target actor
					// may extend with a check that its actor exists as a part.
					asm.remoteActor = sig.getSenderRole(); // store it to later
					// if (asm.findRoleSpec(rpm.targetActor.getActorType(),
					// asm.getParts()) != null) {
					// part type exists
					asm.setTraceLevel(sig.getInt(TRACE_LEVEL_PROP));
					ActorAddress target = (ActorAddress) ((ActorAddress) sig.getProperty(TARGET_ACTOR)).clone();
					sig.setProperty(TARGET_ACTOR, null);
					// sig.setTargetActor(null);
					asm.sendMessage(sig, target);
					nextState(waitCreation, curfsm);

					return;
				} else {
					nextState(idle, curfsm);
					// exec super
					super.execTrans(sig, st, curfsm);

					return;
				}
			} else if (sig.equals(ROLE_PLAY_MSG)) {
				// RolePlayMsg rpm = (RolePlayMsg) sig;
				ActorAddress targetActor = (ActorAddress) sig.getProperty(TARGET_ACTOR);

				if (targetActor != null) {
					// forward this message to the target actor
					// may extend with a check that its actor exists as a part.
					asm.remoteActor = sig.getSenderRole(); // store it to later

					ActorAddress target = (ActorAddress) ((ActorAddress) sig.getProperty(TARGET_ACTOR)).clone();
					sig.setProperty(TARGET_ACTOR, null);
					asm.sendMessage(sig, target);
					sameState(curfsm);
					nextState(waitCreation, curfsm);

					return;
				} else {
					nextState(idle, curfsm);
					// exec super
					super.execTrans(sig, st, curfsm);

					return;
				}
			}
		} else if (st == waitCreation) {
			if (sig.equals(ROLE_CREATE_ACK_MSG)) {
				performExit(curfsm);
				sig.setReceiverRole(asm.remoteActor);
				asm.sendMessage(sig);
				asm.internalActors.addElement(sig.getSenderRole());
				// ensure that the router is updated with all actors
				asm.getScheduler().upDateVisibleActors(asm);
				nextState(idle, curfsm);

				return;
			} else if (sig.equals(ROLE_CREATE_NACK_MSG)) {
				performExit(curfsm);
				sig.setReceiverRole(asm.remoteActor);
				asm.sendMessage(sig);
				nextState(idle, curfsm);

				return;
			} else if (sig.equals(ROLE_PLAY_ACK_MSG)) {
				performExit(curfsm);
				sig.setReceiverRole(asm.remoteActor);
				asm.sendMessage(sig);
				asm.internalActors.addElement(sig.getSenderRole());
				// ensure that the router is updated with all actors
				asm.getScheduler().upDateVisibleActors(asm);
				nextState(idle, curfsm);

				return;
			} else if (sig.equals(ROLE_CREATE_MSG)) {
				save(sig, curfsm);

				return;
			} else if (sig.equals(ROLE_PLAY_MSG)) {
				save(sig, curfsm);

				return;
			}
		} /*
		 * else if (st == actorSuspended){ if
		 * (sig.equals(APPLICATION_SPEC_CHANGED_MSG)) { // check all actor types
		 * to see if the actor spec has changed. // send roleUpdate msg to those
		 * instances of that type ApplicationSpec newApppec =
		 * (ApplicationSpec)sig
		 * .getProperty(APPLICATION_SPEC_CHANGED_MSG_APP_SPEC); Enumeration en =
		 * asm.getApplicationSpec().getActorSpecs().elements(); while
		 * (en.hasMoreElements()) { ActorSpec oldActorSpec = (ActorSpec)
		 * en.nextElement(); ActorSpec newActorSpec =
		 * (ActorSpec)newApppec.getActorSpecs
		 * ().get(oldActorSpec.getActorType()); if
		 * (oldActorSpec.equals(newActorSpec)) continue; // send an update msg
		 * to all instances of that type
		 * 
		 * }
		 * 
		 * 
		 * 
		 * } }
		 */

		// execute super behavior
		super.execTrans(sig, st, curfsm);

		if (asm.isSaveDone()) {
			return;
		}

		// Update the router with visible actors in this schedulerData
		if (sig.equals(TIMER_MSG)) {
			AFPropertyMsg am = (AFPropertyMsg) sig;

			if (am.getProperty(TIMER_ID).equals(TIMER_ACTOR_REG_ID)) {
				// update visible statemachines
				asm.getScheduler().upDateVisibleActors(asm);
				asm.setTraceLevel(TraceConstants.tlWarn);
				asm.startTimer(TIMER_ACTOR_REG, TIMER_ACTOR_REG_ID);

				sameState(curfsm);

	            return;
			}

		}

	}
}
