/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe;

import org.coos.javaframe.ActorAddress;

import java.util.Vector;

/**
 * @author Geir Melby, Tellu AS
 * @author Knut Eilif Husa, Tellu AS
 */
public class ActorDomainSM extends ActorSM {
	public ActorAddress remoteActor;
	public java.util.Vector internalActors;

	/**
	 * Called if an sub type is initiated. Then the default constructer should
	 * not be used because new Composite state will be created
	 */
	public ActorDomainSM() {
		setBehaviorClass(new ActorDomainCS("ActorDomain"));
	}

	/**
	 * Prints out the state data for current actor instance. May be ommitted.
	 * 
	 * @return a string representation of the state data
	 */
	public String printStateData() {
		return super.printStateData();
	}

	protected void initInstance() {
		super.initInstance();
		// make the actor be global visible
		setVisible(true);
		internalActors = new Vector();
		remoteActor = new ActorAddress();

		// setTraceLevel(TraceConstants.tlDebug);
	}

	/**
	 * /** Create the context for an instance of this state machine in current
	 * context. This method overrides super in StateMachine to create correct
	 * context string
	 * 
	 * @return A context string that makes the actorid unique
	 */
	public final String getContextString() {
		return "/";
	}
}
