/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe;

import org.coos.javaframe.ActorAddress;
import org.coos.javaframe.PortSpec;
import org.coos.util.serialize.AFClassLoader;
import org.coos.util.serialize.AFSerializer;
import org.coos.javaframe.messages.ActorAddressHelper;

import java.io.*;

/**
 * This class contains the nec. information to create a port and the connectors
 * which it shall set up upon creation.
 * 
 * @author Geir Melby, Tellu AS
 */
public class ActorPortSpec extends PortSpec implements AFSerializer {
	boolean isBehavior = false; // Flag indicating behavior Port.
	boolean sessionEnabled = false; // Flag indicating whether client sessions
	// are enabled.
	boolean hideInner = false; // Hide inner structure from other clients.
	ActorAddress actorDomain = null;

	public ActorPortSpec() {
	}

	public ActorPortSpec(String portName, String portType, boolean isBehavior) {
		super(portName, portType, null);
		this.isBehavior = isBehavior;
	}

	public ActorPortSpec(String portName) {
		super(portName, null, null);
		this.isBehavior = false;
	}

	public ActorAddress getActorDomain() {
		return actorDomain;
	}

	public void setActorDomain(ActorAddress actorDomain) {
		this.actorDomain = actorDomain;
	}

	public void setPortName(String portName) {
		this.portName = portName;
	}

	public void setPortType(String portType) {
		this.portType = portType;
	}

	public void setIsBehavior(boolean isBehavior) {
		this.isBehavior = isBehavior;
	}

	public boolean getIsBehavior() {
		return this.isBehavior;
	}

	public boolean isHideInner() {
		return hideInner;
	}

	public void setHideInner(boolean hideInner) {
		this.hideInner = hideInner;
	}

	public boolean isBehavior() {
		return isBehavior;
	}

	public void setBehavior(boolean behavior) {
		isBehavior = behavior;
	}

	public boolean isSessionEnabled() {
		return sessionEnabled;
	}

	public void setSessionEnabled(boolean sessionEnabled) {
		this.sessionEnabled = sessionEnabled;
	}

	public Object clone() {
		ActorPortSpec actorPortSpec = new ActorPortSpec(portName, portType, isBehavior);
		actorPortSpec.hideInner = hideInner;
		actorPortSpec.sessionEnabled = sessionEnabled;

		if (this.actorDomain != null) {
			actorPortSpec.setActorDomain((ActorAddress) this.actorDomain.clone());
		}

		return actorPortSpec;
	}

	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (!super.equals(o)) {
			return false;
		}

		if (o == null || getClass() != o.getClass())
			return false;

		ActorPortSpec that = (ActorPortSpec) o;

		if (hideInner != that.hideInner)
			return false;
		if (isBehavior != that.isBehavior)
			return false;
		if (sessionEnabled != that.sessionEnabled)
			return false;
		if (actorDomain != null ? !actorDomain.equals(that.actorDomain) : that.actorDomain != null)
			return false;

		return super.equals(o);
	}

	public String toString() {
		return super.toString() + " isBeaviour: " + isBehavior + " sessionEnabled: " + sessionEnabled + " hideInner: "
				+ hideInner;
	}

	/**
	 * Parse Element to create the ActorPortSpec.
	 * 
	 * @param e
	 *            org.jdom.Element to parse.
	 */

	/*
	 * public ActorPortSpec(org.jdom.Element e) { portName =
	 * e.getChildTextTrim("name"); portType = e.getChildTextTrim("type"); String
	 * strIsBehavior = e.getChildTextTrim("isbehavior"); String strHideInner =
	 * e.getChildTextTrim("hideinner"); String strSessionEnabled =
	 * e.getChildTextTrim("sessions"); isBehavior = ((strIsBehavior != null) &&
	 * strIsBehavior.equalsIgnoreCase("true")); hideInner = ((strHideInner !=
	 * null) && strHideInner.equalsIgnoreCase("true")); sessionEnabled =
	 * ((strSessionEnabled != null) &&
	 * strSessionEnabled.equalsIgnoreCase("true")); }
	 */

	/**
	 * This function must implement the serialization of the object.
	 * 
	 * @return a byte array with the objects data
	 * @throws java.io.IOException
	 */
	public byte[] serialize() throws IOException {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		DataOutputStream dout = new DataOutputStream(bout);
		dout.write(super.serialize());
		dout.writeBoolean(isBehavior);
		dout.writeBoolean(hideInner);
		dout.writeBoolean(sessionEnabled);
		dout.write(ActorAddressHelper.persist(actorDomain));
		dout.flush();

		return bout.toByteArray();
	}

	/**
	 * Use this function for resurrection of the object.
	 * 
	 * @param data
	 *            The serialized data containing the object data.
	 * @throws java.io.IOException
	 */
	public ByteArrayInputStream deSerialize(byte[] data, AFClassLoader cl) throws IOException {
		ByteArrayInputStream bin = super.deSerialize(data, cl);
		DataInputStream din = new DataInputStream(bin);
		isBehavior = din.readBoolean();
		hideInner = din.readBoolean();
		sessionEnabled = din.readBoolean();
		actorDomain = ActorAddressHelper.resurrect(din);

		return bin;
	}
}
