/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.actorframe.application;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public interface ApplicationConstants {
	public static final String ACTOR_DOMAIN_NAME = "ActorDomainName";
	public static final String APPLICATION_NAME = "ApplicationName";
	public static final String ACTOR_GATEWAY_IP = "ActorGatewayIP";
	public static final String ACTOR_GATEWAY_PORT_NUMBER = "ActorGatewayPortNumb";
	public static final String SERVER_PORT_NUMBER = "ServerPortNumber";
	public static final String HOST_IP_ADDRESS = "HostIPAddress";
	public static final String NAME_SERVER = "NameServer";
	public static final String RESOURCE_SERVER = "ResourceServer";
	public static final String USER_NAME = "UserName";
	public static final String USER_PASSWORD = "Password";
	public static final String ACTOR_ROUTER_ADDRESS = "RouterAddress";
	public static final String APPLICATION_SPEC = "ApplicationSpec";
	public static final String SCHEDULER_DATA = "SchedulerData";

	// Describes the state of the system
	public static final int STATE_CREATED = 0;
	public static final int STATE_INITIALIZING = 1;
	public static final int STATE_INITIALIZED = 2;
	public static final int STATE_ACTIVE = 3;
	public static final int STATE_SUSPENDING = 4;
	public static final int STATE_SUSPENDED = 5;
	public static final int STATE_DELETED = 6;
	public static final int STATE_RESUMING = 7;
	public static final int STATE_UPDATING = 8;
	public static final int STATE_UPDATED = 9;

	// todo hall this constants be moved to the message bus
	// Describes the different kind of applications
	// "S" runs as a server
	// "C" runs as client
	// "A" ??
	public static final String SERVER = "S";
	public static final String CLIENT = "C";
	public static final String DOMAIN = "A";

	/*
	 * public void deleteApp(); public void deleteStartCanvas();
	 */
}
