/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import java.util.Date;

/**
 * 
 * @author Geir Melby, Tellu AS
 */
public class BasicLoggerImpl implements Logger {
	String loggername;
	int traceLevel;
	static Date date;

	public BasicLoggerImpl(String loggername) {
		this.loggername = loggername;
		System.out.println("Default logger: " + loggername + " is initiated");
	}

	public BasicLoggerImpl() {
		System.out.println("BasicLoggerImpl is used");
	}

	public void log(int level, int categories, String value) {
		switch (level) {
		case TraceConstants.tlError:
			System.err.println(getTimeString() + " ERROR " + loggername + " " + value);

			break;

		case TraceConstants.tlFatal:
			System.err.println(getTimeString() + " FATAL " + loggername + " " + value);

			break;

		case TraceConstants.tlWarn:
			System.out.println(getTimeString() + " WARN " + loggername + " " + value);

			break;

		case TraceConstants.tlInfo:
			System.out.println(getTimeString() + " INFO " + loggername + " " + value);

			break;

		case TraceConstants.tlDebug:
			System.out.println(getTimeString() + " DEBUG " + loggername + " " + value);

			break;
		}
	}

	private static String getTimeString() {
		return new Date(System.currentTimeMillis()).toString();
	}

	public void log(int level, String value) {
		log(traceLevel, TraceConstants.tcAllOn, value);
	}

	public String getLoggerName() {
		return loggername;
	}

	public void setLoggerName(String loggerName) {
		this.loggername = loggerName;
	}

	public void setTraceLevel(int traceLevel) {
		this.traceLevel = traceLevel;
	}

	public boolean isDebugEnabled() {
		return LoggerFactory.isTraceOn() && traceLevel >= TraceConstants.tlDebug;
	}

	public boolean isErrorEnabled() {
		return LoggerFactory.isTraceOn() && traceLevel >= TraceConstants.tlError;
	}

	public boolean isInfoEnabled() {
		return LoggerFactory.isTraceOn() && traceLevel >= TraceConstants.tlInfo;
	}

	public boolean isTraceEnabled() {
		return LoggerFactory.isTraceOn() && isDebugEnabled(); // We are using
		// Debug for our
		// trace...
	}

	public boolean isWarnEnabled() {
		return LoggerFactory.isTraceOn() && traceLevel >= TraceConstants.tlWarn;
	}

}
