/**
 * COOS - Connected Objects Operating System (www.connectedobjects.org).
 *
 * Copyright (C) 2009 Telenor ASA and Tellu AS. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also contact one of the following for additional information:
 * Telenor ASA, Snaroyveien 30, N-1331 Fornebu, Norway (www.telenor.no)
 * Tellu AS, Hagalokkveien 13, N-1383 Asker, Norway (www.tellu.no)
 */
package org.coos.javaframe;

import java.io.IOException;
import java.io.OutputStream;

import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

/**
 * Logging event.
 * 
 * @author Knut Eilif Husa, Tellu AS
 */
public class CLDCLoggingEvent // extends MIDlet

{
	private byte[] seg1 = { (byte) 0xac, (byte) 0xed, (byte) 0x00, (byte) 0x05, (byte) 0x73, (byte) 0x72, (byte) 0x00,
			(byte) 0x21, (byte) 0x6F, (byte) 0x72, (byte) 0x67, (byte) 0x2e, (byte) 0x61, (byte) 0x70, (byte) 0x61,
			(byte) 0x63, (byte) 0x68, (byte) 0x65, (byte) 0x2e, (byte) 0x6C, (byte) 0x6F, (byte) 0x67, (byte) 0x34,
			(byte) 0x6A, (byte) 0x2E, (byte) 0x73, (byte) 0x70, (byte) 0x69, (byte) 0x2E, (byte) 0x4C, (byte) 0x6F,
			(byte) 0x67, (byte) 0x67, (byte) 0x69, (byte) 0x6E, (byte) 0x67, (byte) 0x45, (byte) 0x76, (byte) 0x65,
			(byte) 0x6E, (byte) 0x74, (byte) 0xF3, (byte) 0xF2, (byte) 0xB9, (byte) 0x23, (byte) 0x74, (byte) 0x0B,
			(byte) 0xB5, (byte) 0x3F, (byte) 0x03, (byte) 0x00, (byte) 0x0A, (byte) 0x5A, (byte) 0x00, (byte) 0x15,
			(byte) 0x6D, (byte) 0x64, (byte) 0x63, (byte) 0x43, (byte) 0x6F, (byte) 0x70, (byte) 0x79, (byte) 0x4C,
			(byte) 0x6F, (byte) 0x6F, (byte) 0x6B, (byte) 0x75, (byte) 0x70, (byte) 0x52, (byte) 0x65, (byte) 0x71,
			(byte) 0x75, (byte) 0x69, (byte) 0x72, (byte) 0x65, (byte) 0x64, (byte) 0x5A, (byte) 0x00, (byte) 0x11,
			(byte) 0x6E, (byte) 0x64, (byte) 0x63, (byte) 0x4C, (byte) 0x6F, (byte) 0x6F, (byte) 0x6B, (byte) 0x75,
			(byte) 0x70, (byte) 0x52, (byte) 0x65, (byte) 0x71, (byte) 0x75, (byte) 0x69, (byte) 0x72, (byte) 0x65,
			(byte) 0x64, (byte) 0x4A, (byte) 0x00, (byte) 0x09, (byte) 0x74, (byte) 0x69, (byte) 0x6D, (byte) 0x65,
			(byte) 0x53, (byte) 0x74, (byte) 0x61, (byte) 0x6D, (byte) 0x70, (byte) 0x4C, (byte) 0x00, (byte) 0x0C,
			(byte) 0x63, (byte) 0x61, (byte) 0x74, (byte) 0x65, (byte) 0x67, (byte) 0x6F, (byte) 0x72, (byte) 0x79,
			(byte) 0x4E, (byte) 0x61, (byte) 0x6D, (byte) 0x65, (byte) 0x74, (byte) 0x00, (byte) 0x12, (byte) 0x4C,
			(byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61, (byte) 0x2F, (byte) 0x6C, (byte) 0x61, (byte) 0x6E,
			(byte) 0x67, (byte) 0x2F, (byte) 0x53, (byte) 0x74, (byte) 0x72, (byte) 0x69, (byte) 0x6E, (byte) 0x67,
			(byte) 0x3B, (byte) 0x4C, (byte) 0x00, (byte) 0x0C, (byte) 0x6C, (byte) 0x6F, (byte) 0x63, (byte) 0x61,
			(byte) 0x74, (byte) 0x69, (byte) 0x6F, (byte) 0x6E, (byte) 0x49, (byte) 0x6E, (byte) 0x66, (byte) 0x6F,
			(byte) 0x74, (byte) 0x00, (byte) 0x23, (byte) 0x4C, (byte) 0x6F, (byte) 0x72, (byte) 0x67, (byte) 0x2F,
			(byte) 0x61, (byte) 0x70, (byte) 0x61, (byte) 0x63, (byte) 0x68, (byte) 0x65, (byte) 0x2F, (byte) 0x6C,
			(byte) 0x6F, (byte) 0x67, (byte) 0x34, (byte) 0x6A, (byte) 0x2F, (byte) 0x73, (byte) 0x70, (byte) 0x69,
			(byte) 0x2F, (byte) 0x4C, (byte) 0x6F, (byte) 0x63, (byte) 0x61, (byte) 0x74, (byte) 0x69, (byte) 0x6F,
			(byte) 0x6E, (byte) 0x49, (byte) 0x6E, (byte) 0x66, (byte) 0x6F, (byte) 0x3B, (byte) 0x4C, (byte) 0x00,
			(byte) 0x07, (byte) 0x6D, (byte) 0x64, (byte) 0x63, (byte) 0x43, (byte) 0x6F, (byte) 0x70, (byte) 0x79,
			(byte) 0x74, (byte) 0x00, (byte) 0x15, (byte) 0x4C, (byte) 0x6A, (byte) 0x61, (byte) 0x76, (byte) 0x61,
			(byte) 0x2F, (byte) 0x75, (byte) 0x74, (byte) 0x69, (byte) 0x6C, (byte) 0x2F, (byte) 0x48, (byte) 0x61,
			(byte) 0x73, (byte) 0x68, (byte) 0x74, (byte) 0x61, (byte) 0x62, (byte) 0x6C, (byte) 0x65, (byte) 0x3B,
			(byte) 0x4C, (byte) 0x00, (byte) 0x03, (byte) 0x6E, (byte) 0x64, (byte) 0x63, (byte) 0x71, (byte) 0x00,
			(byte) 0x7E, (byte) 0x00, (byte) 0x01, (byte) 0x4C, (byte) 0x00, (byte) 0x0F, (byte) 0x72, (byte) 0x65,
			(byte) 0x6E, (byte) 0x64, (byte) 0x65, (byte) 0x72, (byte) 0x65, (byte) 0x64, (byte) 0x4D, (byte) 0x65,
			(byte) 0x73, (byte) 0x73, (byte) 0x61, (byte) 0x67, (byte) 0x65, (byte) 0x71, (byte) 0x00, (byte) 0x7E,
			(byte) 0x00, (byte) 0x01, (byte) 0x4C, (byte) 0x00, (byte) 0x0A, (byte) 0x74, (byte) 0x68, (byte) 0x72,
			(byte) 0x65, (byte) 0x61, (byte) 0x64, (byte) 0x4E, (byte) 0x61, (byte) 0x6D, (byte) 0x65, (byte) 0x71,
			(byte) 0x00, (byte) 0x7E, (byte) 0x00, (byte) 0x01, (byte) 0x4C, (byte) 0x00, (byte) 0x0D, (byte) 0x74,
			(byte) 0x68, (byte) 0x72, (byte) 0x6F, (byte) 0x77, (byte) 0x61, (byte) 0x62, (byte) 0x6C, (byte) 0x65,
			(byte) 0x49, (byte) 0x6E, (byte) 0x66, (byte) 0x6F, (byte) 0x74, (byte) 0x00, (byte) 0x2B, (byte) 0x4C,
			(byte) 0x6F, (byte) 0x72, (byte) 0x67, (byte) 0x2F, (byte) 0x61, (byte) 0x70, (byte) 0x61, (byte) 0x63,
			(byte) 0x68, (byte) 0x65, (byte) 0x2F, (byte) 0x6C, (byte) 0x6F, (byte) 0x67, (byte) 0x34, (byte) 0x6A,
			(byte) 0x2F, (byte) 0x73, (byte) 0x70, (byte) 0x69, (byte) 0x2F, (byte) 0x54, (byte) 0x68, (byte) 0x72,
			(byte) 0x6F, (byte) 0x77, (byte) 0x61, (byte) 0x62, (byte) 0x6C, (byte) 0x65, (byte) 0x49, (byte) 0x6E,
			(byte) 0x66, (byte) 0x6F, (byte) 0x72, (byte) 0x6D, (byte) 0x61, (byte) 0x74, (byte) 0x69, (byte) 0x6F,
			(byte) 0x6E, (byte) 0x3B, (byte) 0x78, (byte) 0x70, (byte) 0x00, (byte) 0x00 };
	private byte[] seg2 = { (byte) 0x70, (byte) 0x70, (byte) 0x70, (byte) 0x74 };
	private byte[] renderedMessage;
	private byte[] ref = { (byte) 116 };
	private byte[] seg3 = { (byte) 112, (byte) 119, (byte) 4 };
	private byte[] seg4 = { (byte) 112, (byte) 120, (byte) 121 };
	private String host;
	private int port;

	public CLDCLoggingEvent(String host, int port) {
		this.host = host;
		this.port = port;
	}

	public void log(String message, String loggerName, int level) {
		renderedMessage = getLenAndBytes(message);

		byte[] threadName = getLenAndBytes(Thread.currentThread().toString());
		byte[] curTime = long2byte(System.currentTimeMillis());
		byte[] categoryName = getLenAndBytes(loggerName);
		byte[] lev = int2byte(level * 10000);

		byte[] totalmessage = append(append(append(append(append(append(append(append(
				append(append(seg1, curTime), ref), categoryName), seg2), renderedMessage), ref), threadName), seg3),
				lev), seg4);

		SocketLogger sl = new SocketLogger();
		sl.open();

		sl.transmit(totalmessage);
	}

	private byte[] append(byte[] pre, byte[] app) {
		int len = pre.length + app.length;
		byte[] res = new byte[len];
		System.arraycopy(pre, 0, res, 0, pre.length);
		System.arraycopy(app, 0, res, pre.length, app.length);

		return res;
	}

	private byte[] getLenAndBytes(String s) {
		byte[] sb = s.getBytes();
		int l = sb.length;
		byte[] lb = new byte[2];
		lb[0] = (byte) ((l >>> 8) & 0xFF);
		lb[1] = (byte) (l & 0xFF);

		byte[] res = new byte[l + 2];
		System.arraycopy(lb, 0, res, 0, 2);
		System.arraycopy(sb, 0, res, 2, l);

		return res;
	}

	private byte[] int2byte(int i) {
		byte[] b = new byte[4];
		b[0] = (byte) ((i >>> 24) & 0xFF);
		b[1] = (byte) ((i >>> 16) & 0xFF);
		b[2] = (byte) ((i >>> 8) & 0xFF);
		b[3] = (byte) (i & 0xFF);

		return b;
	}

	private byte[] long2byte(long l) {
		byte[] b = new byte[8];
		b[0] = (byte) ((l >>> 56) & 0xFF);
		b[1] = (byte) ((l >>> 48) & 0xFF);
		b[2] = (byte) ((l >>> 40) & 0xFF);
		b[3] = (byte) ((l >>> 32) & 0xFF);
		b[4] = (byte) ((l >>> 24) & 0xFF);
		b[5] = (byte) ((l >>> 16) & 0xFF);
		b[6] = (byte) ((l >>> 8) & 0xFF);
		b[7] = (byte) (l & 0xFF);

		return b;
	}

	private class SocketLogger {
		StreamConnection conn = null;
		OutputStream out = null;

		void open() {
			try {
				conn = (StreamConnection) Connector.open("socket://" + host + ":" + port);
				out = conn.openOutputStream();
			} catch (IOException e) {
				e.printStackTrace(); // To change body of catch statement use
				// File | Settings | File Templates.
			}
		}

		void transmit(byte[] mesg) {
			try {
				out.write(mesg);
				out.flush();
			} catch (IOException e) {
				e.printStackTrace(); // To change body of catch statement use
				// File | Settings | File Templates.
			}
		}
	}

	/*
	 * protected void container() throws MIDletStateChangeException {
	 * log("Dette er en annen test", "Error", 10000); }
	 * 
	 * protected void pauseApp() { //To change body of implemented methods use
	 * File | Settings | File Templates. }
	 * 
	 * protected void destroyApp(boolean b) throws MIDletStateChangeException {
	 * //To change body of implemented methods use File | Settings | File
	 * Templates. }
	 */
}
