/*
 * Decompiled with CFR 0.152.
 */
package org.cosinus.swing.test.storage;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cosinus.swing.store.ApplicationStorage;
import org.cosinus.swing.test.storage.DirtiesApplicationStorage;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class DirtiesApplicationStorageTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Logger LOG = LogManager.getLogger(DirtiesApplicationStorageTestExecutionListener.class);

    protected void cleanupApplicationStorage(TestContext testContext) {
        try {
            ApplicationStorage applicationStorage = (ApplicationStorage)testContext.getApplicationContext().getBean(ApplicationStorage.class);
            applicationStorage.clear();
        }
        catch (BeansException ex) {
            LOG.error("Cannot find ApplicationStorage bean in context for cleaning test annotated with @DirtiesApplicationStorage", (Throwable)ex);
        }
    }

    public void afterTestMethod(@NotNull TestContext testContext) {
        DirtiesApplicationStorage methodAnnotation = (DirtiesApplicationStorage)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)testContext.getTestMethod(), DirtiesApplicationStorage.class);
        DirtiesApplicationStorage classAnnotation = (DirtiesApplicationStorage)TestContextAnnotationUtils.findMergedAnnotation((Class)testContext.getTestClass(), DirtiesApplicationStorage.class);
        boolean dirtiesApplicationStorage = Optional.ofNullable(methodAnnotation).or(() -> Optional.ofNullable(classAnnotation)).map(DirtiesApplicationStorage::value).orElse(true);
        if (dirtiesApplicationStorage) {
            if (LOG.isDebugEnabled()) {
                if (methodAnnotation != null) {
                    LOG.debug(String.format("After test method: context %s, method annotated with @DirtiesApplicationStorage.", testContext));
                } else if (classAnnotation != null) {
                    LOG.debug(String.format("After test method: context %s, class annotated with @DirtiesApplicationStorage.", testContext));
                } else {
                    LOG.debug(String.format("After test method: context %s, no @DirtiesApplicationStorage annotation.", testContext));
                }
            }
            this.cleanupApplicationStorage(testContext);
        }
    }

    public void afterTestClass(@NotNull TestContext testContext) {
        DirtiesApplicationStorage classAnnotation = (DirtiesApplicationStorage)TestContextAnnotationUtils.findMergedAnnotation((Class)testContext.getTestClass(), DirtiesApplicationStorage.class);
        boolean dirtiesApplicationStorage = Optional.ofNullable(classAnnotation).map(DirtiesApplicationStorage::value).orElse(true);
        if (dirtiesApplicationStorage) {
            if (LOG.isDebugEnabled()) {
                if (classAnnotation != null) {
                    LOG.debug(String.format("After test class: context %s, class annotated with @DirtiesApplicationStorage.", testContext));
                } else {
                    LOG.debug(String.format("After test class: context %s, no @DirtiesApplicationStorage annotation.", testContext));
                }
            }
            this.cleanupApplicationStorage(testContext);
        }
    }
}

