/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.ebus.config;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.craftercms.commons.ebus.annotations.EventHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.common.TemplateAwareExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import reactor.core.Observable;
import reactor.event.Event;
import reactor.event.selector.Selector;
import reactor.event.selector.Selectors;
import reactor.function.Consumer;
import reactor.function.Function;
import reactor.util.StringUtils;

public class EBusBeanAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    private static final ReflectionUtils.MethodFilter LISTENER_METHOD_FILTER = new ReflectionUtils.MethodFilter(){

        public boolean matches(Method method) {
            return AnnotationUtils.findAnnotation((Method)method, EventHandler.class) != null;
        }
    };
    private boolean started = false;
    private ApplicationContext applicationContext;
    private ConversionService conversionService;
    private BeanResolver beanResolver;
    private TemplateAwareExpressionParser expressionParser = new SpelExpressionParser();

    private static Set<Method> findHandlerMethods(Class<?> handlerType, final ReflectionUtils.MethodFilter listenerMethodFilter) {
        final LinkedHashSet<Method> handlerMethods = new LinkedHashSet<Method>();
        if (handlerType == null) {
            return handlerMethods;
        }
        LinkedHashSet handlerTypes = new LinkedHashSet();
        Class specifiedHandlerType = null;
        if (!Proxy.isProxyClass(handlerType)) {
            handlerTypes.add(handlerType);
            specifiedHandlerType = handlerType;
        }
        handlerTypes.addAll(Arrays.asList(handlerType.getInterfaces()));
        for (Class clazz : handlerTypes) {
            final Class targetClass = specifiedHandlerType != null ? specifiedHandlerType : clazz;
            ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
                    Method bridgeMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
                    if (listenerMethodFilter.matches(specificMethod) && (bridgeMethod == specificMethod || !listenerMethodFilter.matches(bridgeMethod))) {
                        handlerMethods.add(specificMethod);
                    }
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return handlerMethods;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        ApplicationContext ctx = contextRefreshedEvent.getApplicationContext();
        if (this.applicationContext != ctx) {
            return;
        }
        if (null == this.beanResolver) {
            this.beanResolver = new BeanFactoryResolver((BeanFactory)ctx);
        }
        if (null == this.conversionService) {
            try {
                this.conversionService = (ConversionService)ctx.getBean("reactorConversionService", ConversionService.class);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
        }
        EBusBeanAutoConfiguration eBusBeanAutoConfiguration = this;
        synchronized (eBusBeanAutoConfiguration) {
            if (this.started) {
                return;
            }
            for (String beanName : ctx.getBeanDefinitionNames()) {
                Class type = ctx.getType(beanName);
                Set<Method> methods = EBusBeanAutoConfiguration.findHandlerMethods(type, LISTENER_METHOD_FILTER);
                if (methods == null || methods.size() <= 0) continue;
                this.wireBean(ctx.getBean(beanName), methods);
            }
            this.started = true;
        }
    }

    private void wireBean(Object bean, Set<Method> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (Method method : methods) {
            EventHandler eventHandlerAnnotation = (EventHandler)AnnotationUtils.findAnnotation((Method)method, EventHandler.class);
            Observable reactor = this.fetchObservable(eventHandlerAnnotation, bean);
            Selector selector = this.fetchSelector(eventHandlerAnnotation, bean, method);
            Invoker handler = new Invoker(bean, method, this.conversionService);
            ServiceConsumer consumer = new ServiceConsumer(handler);
            reactor.on(selector, (Consumer)consumer);
        }
    }

    private <T> T expression(String selector, Object bean) {
        if (selector == null) {
            return null;
        }
        StandardEvaluationContext evalCtx = new StandardEvaluationContext();
        evalCtx.setRootObject(bean);
        evalCtx.setBeanResolver(this.beanResolver);
        return (T)this.expressionParser.parseExpression(selector).getValue((EvaluationContext)evalCtx);
    }

    private Observable fetchObservable(EventHandler eventHandlerAnnotation, Object bean) {
        return (Observable)this.expression(eventHandlerAnnotation.ebus(), bean);
    }

    protected Object parseSelector(EventHandler eventHandlerAnnotation, Object bean, Method method) {
        if (!StringUtils.isEmpty((Object)eventHandlerAnnotation.event())) {
            return eventHandlerAnnotation.event();
        }
        try {
            return this.expression(eventHandlerAnnotation.event(), bean);
        }
        catch (Exception e) {
            return eventHandlerAnnotation.event();
        }
    }

    private Selector fetchSelector(EventHandler eventHandlerAnnotation, Object bean, Method method) {
        Object selector = this.parseSelector(eventHandlerAnnotation, bean, method);
        switch (eventHandlerAnnotation.type()) {
            case OBJECT: {
                return Selectors.object((Object)selector);
            }
            case REGEX: {
                return Selectors.regex((String)selector.toString());
            }
        }
        return Selectors.object((Object)selector);
    }

    protected static final class Invoker
    implements Function<Event, Object> {
        private final Method method;
        private final Object bean;
        private final Class<?>[] argTypes;
        private final ConversionService conversionService;

        Invoker(Object bean, Method method, ConversionService conversionService) {
            this.bean = bean;
            this.method = method;
            this.argTypes = method.getParameterTypes();
            this.conversionService = conversionService;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object getBean() {
            return this.bean;
        }

        public Class<?>[] getArgTypes() {
            return this.argTypes;
        }

        public Object apply(Event event) {
            if (this.argTypes == null || this.argTypes.length < 1) {
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean);
            }
            if (this.argTypes.length > 1) {
                throw new IllegalStateException("Multiple parameters not yet supported.");
            }
            if (Event.class.isAssignableFrom(this.argTypes[0])) {
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{event});
            }
            if (null == event.getData() || this.argTypes[0].isAssignableFrom(event.getData().getClass())) {
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{event.getData()});
            }
            if (!this.argTypes[0].isAssignableFrom(event.getClass()) && this.conversionService.canConvert(event.getClass(), this.argTypes[0])) {
                ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{this.conversionService.convert((Object)event, this.argTypes[0])});
            }
            if (this.conversionService.canConvert(event.getData().getClass(), this.argTypes[0])) {
                Object convertedObj = this.conversionService.convert(event.getData(), this.argTypes[0]);
                return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])new Object[]{convertedObj});
            }
            throw new IllegalArgumentException("Cannot invoke method " + this.method + " passing parameter " + event.getData());
        }
    }

    protected static final class ServiceConsumer
    implements Consumer<Event> {
        private final Invoker handler;

        public ServiceConsumer(Invoker handler) {
            this.handler = handler;
        }

        public Invoker getHandler() {
            return this.handler;
        }

        public void accept(Event event) {
            this.handler.apply(event);
        }
    }
}

