/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.auth;

import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.Session;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;

public abstract class AbstractSshAuthConfigurator
implements GitAuthenticationConfigurator {
    public static final String KEY_TYPE_CONFIG = "server_host_key";

    @Override
    public void configureAuthentication(TransportCommand command) {
        SshSessionFactory sessionFactory = this.createSessionFactory();
        command.setTransportConfigCallback(transport -> ((SshTransport)transport).setSshSessionFactory(sessionFactory));
    }

    protected void setHostKeyType(OpenSshConfig.Host host, Session session) {
        HostKey[] hostKeys;
        for (HostKey hostKey : hostKeys = session.getHostKeyRepository().getHostKey()) {
            if (!hostKey.getHost().contains(host.getHostName())) continue;
            session.setConfig(KEY_TYPE_CONFIG, hostKey.getType());
        }
    }

    protected abstract SshSessionFactory createSessionFactory();
}

