/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.auth;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.git.auth.AbstractSshAuthConfigurator;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.util.FS;

public class SshRsaKeyPairAuthConfigurator
extends AbstractSshAuthConfigurator {
    protected String privateKeyPath;
    protected String passphrase;

    public void setPrivateKeyPath(String privateKeyPath) {
        this.privateKeyPath = privateKeyPath;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    @Override
    protected SshSessionFactory createSessionFactory() {
        return new JschConfigSessionFactory(){

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                JSch defaultJSch = super.createDefaultJSch(fs);
                if (StringUtils.isNotEmpty((CharSequence)SshRsaKeyPairAuthConfigurator.this.privateKeyPath)) {
                    if (StringUtils.isNotEmpty((CharSequence)SshRsaKeyPairAuthConfigurator.this.passphrase)) {
                        defaultJSch.addIdentity(SshRsaKeyPairAuthConfigurator.this.privateKeyPath, SshRsaKeyPairAuthConfigurator.this.passphrase);
                    } else {
                        defaultJSch.addIdentity(SshRsaKeyPairAuthConfigurator.this.privateKeyPath);
                    }
                }
                return defaultJSch;
            }

            protected void configure(OpenSshConfig.Host host, Session session) {
                SshRsaKeyPairAuthConfigurator.this.setHostKeyType(host, session);
            }
        };
    }
}

