/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.utils;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;

public abstract class GitUtils {
    public static List<DiffEntry> doDiff(Git git, ObjectReader reader, ObjectId fromCommitId, ObjectId toCommitId) throws IOException, GitAPIException {
        AbstractTreeIterator fromTreeIter = GitUtils.getTreeIteratorForCommit(git, reader, fromCommitId);
        AbstractTreeIterator toTreeIter = GitUtils.getTreeIteratorForCommit(git, reader, toCommitId);
        return git.diff().setOldTree(fromTreeIter).setNewTree(toTreeIter).call();
    }

    public static AbstractTreeIterator getTreeIteratorForCommit(Git git, ObjectReader reader, ObjectId commitId) throws IOException {
        if (commitId != null) {
            RevTree tree = GitUtils.getTreeForCommit(git.getRepository(), commitId);
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            treeParser.reset(reader, (AnyObjectId)tree.getId());
            return treeParser;
        }
        return new EmptyTreeIterator();
    }

    public static RevTree getTreeForCommit(Repository repo, ObjectId commitId) throws IOException {
        try (RevWalk revWalk = new RevWalk(repo);){
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
            RevTree revTree = commit.getTree();
            return revTree;
        }
    }
}

