/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.auth;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.git.auth.AbstractSshAuthConfigurator;
import org.craftercms.commons.git.jgit.SshPrivateKeySessionFactory;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class SshPrivateKeyAuthConfigurator
extends AbstractSshAuthConfigurator {
    protected final String privateKeyPath;
    protected final String passphrase;

    public SshPrivateKeyAuthConfigurator(File sshConfig, String privateKeyPath, String passphrase) {
        super(sshConfig);
        this.privateKeyPath = privateKeyPath;
        this.passphrase = passphrase;
    }

    @Override
    public void configureAuthentication(TransportCommand<?, ?> command) {
        if (StringUtils.isNotEmpty((CharSequence)this.passphrase)) {
            command.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(null, this.passphrase));
        }
        super.configureAuthentication(command);
    }

    @Override
    protected SshSessionFactory createSessionFactory() {
        return new SshPrivateKeySessionFactory(this.sshConfig, Paths.get(this.privateKeyPath, new String[0]));
    }
}

