/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.RemoteSetUrlCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitUtils {
    private static final Logger logger = LoggerFactory.getLogger(GitUtils.class);
    public static final String GIT_FOLDER_NAME = ".git";
    public static final String GIT_INDEX_NAME = "index";
    public static final String GIT_LOCK_NAME = "index.lock";
    public static final String CORE_CONFIG_SECTION = "core";
    public static final String BIG_FILE_THRESHOLD_CONFIG_PARAM = "bigFileThreshold";
    public static final String COMPRESSION_CONFIG_PARAM = "compression";
    public static final String FILE_MODE_CONFIG_PARAM = "fileMode";
    public static final String BIG_FILE_THRESHOLD_DEFAULT = "20m";
    public static final int COMPRESSION_DEFAULT = 0;
    public static final boolean FILE_MODE_DEFAULT = false;

    public static List<DiffEntry> doDiff(Git git, ObjectReader reader, ObjectId fromCommitId, ObjectId toCommitId) throws IOException, GitAPIException {
        AbstractTreeIterator fromTreeIter = GitUtils.getTreeIteratorForCommit(git, reader, fromCommitId);
        AbstractTreeIterator toTreeIter = GitUtils.getTreeIteratorForCommit(git, reader, toCommitId);
        return git.diff().setOldTree(fromTreeIter).setNewTree(toTreeIter).call();
    }

    public static AbstractTreeIterator getTreeIteratorForCommit(Git git, ObjectReader reader, ObjectId commitId) throws IOException {
        if (commitId != null) {
            RevTree tree = GitUtils.getTreeForCommit(git.getRepository(), commitId);
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            treeParser.reset(reader, (AnyObjectId)tree.getId());
            return treeParser;
        }
        return new EmptyTreeIterator();
    }

    public static RevTree getTreeForCommit(Repository repo, ObjectId commitId) throws IOException {
        try (RevWalk revWalk = new RevWalk(repo);){
            RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
            RevTree revTree = commit.getTree();
            return revTree;
        }
    }

    public static Git openRepository(File localRepositoryFolder) throws IOException {
        return Git.open((File)localRepositoryFolder);
    }

    public static Git cloneRemoteRepository(String remoteName, String remoteUrl, String branch, GitAuthenticationConfigurator authConfigurator, File localFolder, String bigFileThreshold, Integer compression, Boolean fileMode) throws GitAPIException, IOException {
        CloneCommand command = Git.cloneRepository();
        command.setRemote(remoteName);
        command.setURI(remoteUrl);
        command.setDirectory(localFolder);
        if (StringUtils.isNotEmpty((CharSequence)branch)) {
            command.setCloneAllBranches(false);
            command.setBranchesToClone(Collections.singletonList("refs/heads/" + branch));
            command.setBranch(branch);
        }
        if (authConfigurator != null) {
            authConfigurator.configureAuthentication((TransportCommand<?, ?>)command);
        }
        Git git = command.call();
        StoredConfig config = git.getRepository().getConfig();
        String bigFileTresholdOrDefault = StringUtils.isEmpty((CharSequence)bigFileThreshold) ? BIG_FILE_THRESHOLD_DEFAULT : bigFileThreshold;
        Integer compressionOrDefault = compression == null ? 0 : compression;
        Boolean fileModeOrDefault = fileMode == null ? false : fileMode;
        config.setString(CORE_CONFIG_SECTION, null, BIG_FILE_THRESHOLD_CONFIG_PARAM, bigFileTresholdOrDefault);
        config.setInt(CORE_CONFIG_SECTION, null, COMPRESSION_CONFIG_PARAM, compressionOrDefault.intValue());
        config.setBoolean(CORE_CONFIG_SECTION, null, FILE_MODE_CONFIG_PARAM, fileModeOrDefault.booleanValue());
        config.save();
        return git;
    }

    public static PullResult pull(Git git, String remoteName, String remoteUrl, String branch, MergeStrategy mergeStrategy, GitAuthenticationConfigurator authConfigurator) throws GitAPIException, URISyntaxException {
        GitUtils.addRemote(git, remoteName, remoteUrl);
        PullCommand command = git.pull();
        command.setRemote(remoteName);
        command.setRemoteBranchName(branch);
        if (mergeStrategy != null) {
            command.setStrategy(mergeStrategy);
        }
        if (authConfigurator != null) {
            authConfigurator.configureAuthentication((TransportCommand<?, ?>)command);
        }
        return command.call();
    }

    public static Iterable<PushResult> push(Git git, String remote, boolean pushAll, String localBranch, String remoteBranch, GitAuthenticationConfigurator authConfigurator, boolean force) throws GitAPIException {
        PushCommand push = git.push();
        push.setRemote(remote);
        push.setForce(force);
        if (pushAll) {
            push.setPushAll();
        } else if (StringUtils.isNotEmpty((CharSequence)remoteBranch)) {
            push.setRefSpecs(new RefSpec[]{new RefSpec(localBranch + ":refs/heads/" + remoteBranch)});
        }
        if (authConfigurator != null) {
            authConfigurator.configureAuthentication((TransportCommand<?, ?>)push);
        }
        return push.call();
    }

    public static void cleanup(String repoPath) throws GitAPIException, IOException {
        try (Git git = GitUtils.openRepository(new File(repoPath));){
            git.gc().call();
        }
    }

    public static void discardAllChanges(Git git) throws GitAPIException {
        git.reset().setMode(ResetCommand.ResetType.HARD).setRef("HEAD").call();
    }

    private static void addRemote(Git git, String remoteName, String remoteUrl) throws GitAPIException, URISyntaxException {
        String currentUrl = git.getRepository().getConfig().getString("remote", remoteName, "url");
        if (StringUtils.isNotEmpty((CharSequence)currentUrl)) {
            if (!currentUrl.equals(remoteUrl)) {
                RemoteSetUrlCommand remoteSetUrl = git.remoteSetUrl();
                remoteSetUrl.setRemoteName(remoteName);
                remoteSetUrl.setRemoteUri(new URIish(remoteUrl));
                remoteSetUrl.call();
            }
        } else {
            RemoteAddCommand remoteAdd = git.remoteAdd();
            remoteAdd.setName(remoteName);
            remoteAdd.setUri(new URIish(remoteUrl));
            remoteAdd.call();
        }
    }

    public static boolean isRepositoryLocked(String repoPath) {
        Path path = Paths.get(repoPath, GIT_FOLDER_NAME, GIT_LOCK_NAME);
        return Files.exists(path, new LinkOption[0]);
    }

    public static void unlock(String repoPath) throws IOException {
        Path path = Paths.get(repoPath, GIT_FOLDER_NAME, GIT_LOCK_NAME);
        logger.warn("The repository '{}' is locked, trying to unlock it", (Object)repoPath);
        GitUtils.deleteFile(path);
        logger.info(".git/index.lock is deleted from repository '{}'", (Object)repoPath);
    }

    public static void deleteGitIndex(String repoPath) throws IOException {
        GitUtils.deleteFile(Paths.get(repoPath, GIT_FOLDER_NAME, GIT_INDEX_NAME));
    }

    protected static void deleteFile(Path file) throws IOException {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            logger.debug("Error deleting file '{}', forcing delete", (Object)file, (Object)e);
            FileUtils.forceDelete((File)file.toFile());
        }
    }
}

