/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.utils;

import java.io.File;
import org.apache.commons.lang3.ObjectUtils;
import org.craftercms.commons.git.auth.BasicUsernamePasswordAuthConfigurator;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.craftercms.commons.git.auth.NoopAuthConfigurator;
import org.craftercms.commons.git.auth.SshPrivateKeyAuthConfigurator;
import org.craftercms.commons.git.utils.AbstractAuthConfiguratorBuilder;

public class TypeBasedAuthConfiguratorBuilder
extends AbstractAuthConfiguratorBuilder {
    protected String authType;

    public TypeBasedAuthConfiguratorBuilder(File sshConfig, String authType) {
        super(sshConfig);
        this.authType = authType;
    }

    @Override
    public GitAuthenticationConfigurator build() {
        switch (this.authType) {
            case "none": {
                this.logger.debug("No authentication will be used");
                return new NoopAuthConfigurator();
            }
            case "basic": {
                if (ObjectUtils.isEmpty((Object)this.username) && ObjectUtils.isEmpty((Object)this.password)) {
                    throw new IllegalStateException("basic auth requires a username or password");
                }
                this.logger.debug("Username/password authentication will be used");
                return new BasicUsernamePasswordAuthConfigurator(this.username, this.password);
            }
            case "token": {
                if (ObjectUtils.isEmpty((Object)this.username)) {
                    throw new IllegalStateException("token auth requires a username");
                }
                this.logger.debug("Token authentication will be used");
                return new BasicUsernamePasswordAuthConfigurator(this.username, "");
            }
            case "key": {
                this.logger.debug("SSH private key authentication will be used");
                return new SshPrivateKeyAuthConfigurator(this.sshConfig, this.privateKeyPath, this.privateKeyPassphrase);
            }
        }
        throw new IllegalStateException("Unsupported auth type " + this.authType);
    }
}

