/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.git.utils;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.git.auth.BasicUsernamePasswordAuthConfigurator;
import org.craftercms.commons.git.auth.GitAuthenticationConfigurator;
import org.craftercms.commons.git.auth.NoopAuthConfigurator;
import org.craftercms.commons.git.auth.SshPasswordAuthConfigurator;
import org.craftercms.commons.git.auth.SshPrivateKeyAuthConfigurator;
import org.craftercms.commons.git.utils.AbstractAuthConfiguratorBuilder;

public class UrlBasedAuthConfiguratorBuilder
extends AbstractAuthConfiguratorBuilder {
    protected static final String GIT_SSH_URL_REGEX = "^(ssh://.+)|([a-zA-Z0-9._-]+@.+)$";
    protected String url;

    public UrlBasedAuthConfiguratorBuilder(File sshConfig, String url) {
        super(sshConfig);
        this.url = url;
    }

    @Override
    public GitAuthenticationConfigurator build() {
        if (this.url.matches(GIT_SSH_URL_REGEX)) {
            if (StringUtils.isNotEmpty((CharSequence)this.privateKeyPath)) {
                this.logger.debug("SSH private key authentication will be used to connect to {}", (Object)this.url);
                return new SshPrivateKeyAuthConfigurator(this.sshConfig, this.privateKeyPath, this.privateKeyPassphrase);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.password)) {
                this.logger.debug("SSH username/password authentication will be used to connect to {}", (Object)this.url);
                return new SshPasswordAuthConfigurator(this.sshConfig, this.password);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.username) || StringUtils.isNotEmpty((CharSequence)this.password)) {
            this.logger.debug("Username/password authentication will be used to connect to {}", (Object)this.url);
            return new BasicUsernamePasswordAuthConfigurator(this.username, this.password);
        }
        this.logger.debug("No authentication will be used to connect to {}", (Object)this.url);
        return new NoopAuthConfigurator();
    }
}

