/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.cache.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.cache.Cache;
import org.craftercms.core.cache.CacheItem;
import org.craftercms.core.cache.CacheLoader;
import org.craftercms.core.cache.impl.CacheItemImpl;
import org.craftercms.core.cache.impl.CacheRefresher;
import org.craftercms.core.cache.impl.CacheStoreAdapter;
import org.craftercms.core.exception.InternalCacheEngineException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.util.cache.CachingAwareObject;
import org.craftercms.core.util.generators.TimestampGenerator;
import org.craftercms.core.util.generators.impl.IncrementalTimestampGenerator;
import org.springframework.beans.factory.annotation.Required;

public class CacheImpl
implements Cache {
    private static final Log logger = LogFactory.getLog(CacheImpl.class);
    protected AtomicInteger ticks = new AtomicInteger(0);
    protected CacheStoreAdapter cacheStoreAdapter;
    protected CacheRefresher cacheRefresher;
    protected TimestampGenerator timestampGenerator = new IncrementalTimestampGenerator();

    @Required
    public void setCacheStoreAdapter(CacheStoreAdapter cacheStoreAdapter) {
        this.cacheStoreAdapter = cacheStoreAdapter;
    }

    public void setCacheRefresher(CacheRefresher cacheRefresher) {
        this.cacheRefresher = cacheRefresher;
    }

    public void setTimestampGenerator(TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    @Override
    public boolean hasScope(String scope) throws InternalCacheEngineException {
        try {
            return this.cacheStoreAdapter.hasScope(scope);
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while checking if the scope " + scope + " exists in the" + " cache", ex);
        }
    }

    @Override
    public Collection<String> getScopes() throws InternalCacheEngineException {
        try {
            return this.cacheStoreAdapter.getScopes();
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while getting the list of available scopes", ex);
        }
    }

    @Override
    public void addScope(String scope, int maxItemsInMemory) throws InternalCacheEngineException {
        try {
            this.cacheStoreAdapter.addScope(scope, maxItemsInMemory);
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while adding scope " + scope, ex);
        }
    }

    @Override
    public void removeScope(String scope) throws InvalidScopeException, InternalCacheEngineException {
        try {
            this.cacheStoreAdapter.removeScope(scope);
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while removing scope " + scope, ex);
        }
    }

    @Override
    public int getSize(String scope) throws InvalidScopeException, InternalCacheEngineException {
        try {
            return this.cacheStoreAdapter.getSize(scope);
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while getting size of scope " + scope, ex);
        }
    }

    @Override
    public Collection<Object> getKeys(String scope) throws InvalidScopeException, InternalCacheEngineException {
        try {
            return this.cacheStoreAdapter.getKeys(scope);
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while getting keys of items within scope " + scope, ex);
        }
    }

    @Override
    public boolean hasKey(String scope, Object key) throws InvalidScopeException, InternalCacheEngineException {
        try {
            return this.cacheStoreAdapter.hasKey(scope, key);
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while checking if the scope " + scope + " has key " + key, ex);
        }
    }

    @Override
    public CacheItem get(String scope, Object key) throws InvalidScopeException, InternalCacheEngineException {
        try {
            CacheItem item = this.cacheStoreAdapter.get(scope, key);
            if (item != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Cache hit: found " + item));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache miss: item with key " + key + " not found in scope " + scope));
            }
            return item;
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while getting item with key " + key + " from scope " + scope, ex);
        }
    }

    @Override
    public CacheItem getWithDependencyCheck(String scope, Object key) throws InvalidScopeException, InternalCacheEngineException {
        try {
            CacheItem item = this.cacheStoreAdapter.get(scope, key);
            if (item != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cache hit: found " + item));
                }
                if (this.haveDependenciesChanged(item)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Dependencies have changed for " + item + ". Removing it from the cache."));
                    }
                    this.cacheStoreAdapter.remove(scope, key);
                    return null;
                }
                return item;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache miss: item with key " + key + " not found in scope " + scope));
            }
            return null;
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while getting item with key " + key + " from scope " + scope, ex);
        }
    }

    @Override
    public void put(String scope, Object key, Object value) throws InvalidScopeException, InternalCacheEngineException {
        this.put(scope, key, value, null, 0L, 0L, null, new Object[0]);
    }

    @Override
    public void put(String scope, Object key, Object value, long expireAfter, long refreshFrequency, CacheLoader loader, Object ... loaderParams) throws InvalidScopeException, InternalCacheEngineException {
        this.put(scope, key, value, null, expireAfter, refreshFrequency, loader, loaderParams);
    }

    @Override
    public void put(String scope, Object key, Object value, List<Object> dependencyKeys) throws InvalidScopeException, InternalCacheEngineException {
        this.put(scope, key, value, dependencyKeys, 0L, 0L, null, new Object[0]);
    }

    @Override
    public void put(String scope, Object key, Object value, List<Object> dependencyKeys, long expireAfter, long refreshFrequency, CacheLoader loader, Object ... loaderParams) throws InvalidScopeException, InternalCacheEngineException {
        if (expireAfter < 0L) {
            throw new IllegalArgumentException("The expireAfter argument should be 0 or positive");
        }
        if (refreshFrequency < 0L) {
            throw new IllegalArgumentException("The refreshFrequency argument should be 0 or positive");
        }
        if (value instanceof CachingAwareObject) {
            CachingAwareObject cachingAwareObj = (CachingAwareObject)value;
            if (CollectionUtils.isEmpty(dependencyKeys)) {
                dependencyKeys = cachingAwareObj.getDependencyKeys();
            }
            cachingAwareObj.setCachingTime(System.currentTimeMillis());
            cachingAwareObj.setScope(scope);
            cachingAwareObj.setKey(key);
        }
        try {
            CacheItemImpl item = new CacheItemImpl(scope, this.ticks.get(), key, value, expireAfter, refreshFrequency, this.timestampGenerator.generate(), dependencyKeys, loader, loaderParams);
            this.cacheStoreAdapter.put(item);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Put into cache: " + item));
            }
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while putting item with key " + key + " into scope " + scope, ex);
        }
    }

    @Override
    public boolean remove(String scope, Object key) throws InvalidScopeException, InternalCacheEngineException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing item with key " + key + " from scope " + scope));
        }
        try {
            return this.cacheStoreAdapter.remove(scope, key);
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while removing item with key " + key + " from scope " + scope, ex);
        }
    }

    @Override
    public void clearAll() throws InternalCacheEngineException {
        try {
            this.cacheStoreAdapter.clearAll();
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while clearing all items from the cache", ex);
        }
    }

    @Override
    public void clearScope(String scope) throws InvalidScopeException, InternalCacheEngineException {
        try {
            this.cacheStoreAdapter.clearScope(scope);
        }
        catch (InvalidScopeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InternalCacheEngineException("Exception while clearing all items from scope " + scope, ex);
        }
    }

    public void tick() {
        this.ticks.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Tick!");
        }
        ArrayList<CacheItem> itemsToRefresh = new ArrayList<CacheItem>();
        try {
            Collection<String> scopes = this.cacheStoreAdapter.getScopes();
            if (CollectionUtils.isNotEmpty(scopes)) {
                for (String scope : scopes) {
                    Collection<Object> keys = this.cacheStoreAdapter.getKeys(scope);
                    if (!CollectionUtils.isNotEmpty(keys)) continue;
                    for (Object key : keys) {
                        CacheItem item = this.cacheStoreAdapter.get(scope, key);
                        if (item != null) {
                            this.doChecks(item, itemsToRefresh);
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)(item + " was removed before it could be checked for " + "expiration/refresh"));
                    }
                }
            }
            if (this.cacheRefresher != null && CollectionUtils.isNotEmpty(itemsToRefresh)) {
                this.cacheRefresher.refreshItems(itemsToRefresh, this);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"Exception while checking items for expiration/refresh", (Throwable)ex);
        }
    }

    protected void doChecks(CacheItem item, List<CacheItem> itemsToRefresh) {
        try {
            boolean expired = this.checkForExpiration(item);
            if (expired) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(item + " was removed because it expired"));
                }
            } else {
                boolean willBeRefreshed = this.checkForRefresh(item, itemsToRefresh);
                if (willBeRefreshed && logger.isDebugEnabled()) {
                    logger.debug((Object)(item + " will be refreshed"));
                }
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Exception while checking " + item + " for expiration/refresh"), (Throwable)ex);
        }
    }

    protected boolean checkForExpiration(CacheItem item) throws Exception {
        if (item.isExpired(this.ticks.get())) {
            this.cacheStoreAdapter.remove(item.getScope(), item.getKey());
            return true;
        }
        return false;
    }

    protected boolean checkForRefresh(CacheItem item, List<CacheItem> itemsToRefresh) {
        if (item.getLoader() != null && item.needsRefresh(this.ticks.get())) {
            itemsToRefresh.add(item);
            return true;
        }
        return false;
    }

    protected boolean haveDependenciesChanged(CacheItem item) throws Exception {
        List<Object> dependencyKeys = item.getDependencyKeys();
        if (CollectionUtils.isNotEmpty(dependencyKeys)) {
            for (Object dependencyKey : dependencyKeys) {
                CacheItem dependency = this.cacheStoreAdapter.get(item.getScope(), dependencyKey);
                if (dependency != null && item.getTimestamp() >= dependency.getTimestamp() && !this.haveDependenciesChanged(dependency)) continue;
                return true;
            }
        }
        return false;
    }
}

