/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.core.exception.CacheException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.service.CacheService;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.util.cache.CacheTemplate;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/api/1/cache"})
public class CacheRestController
extends RestControllerBase {
    private static final Log logger = LogFactory.getLog(CacheRestController.class);
    public static final String URL_ROOT = "/cache";
    public static final String URL_CLEAR_ALL_SCOPES = "/clear_all";
    public static final String URL_CLEAR_SCOPE = "/clear";
    public static final String URL_REMOVE_ITEM = "/remove";
    public static final String REQUEST_PARAM_CONTEXT_ID = "contextId";
    public static final String REQUEST_PARAM_URL = "url";
    private CacheTemplate cacheTemplate;
    private ContentStoreService storeService;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @RequestMapping(value={"/clear_all"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearAllScopes() throws CacheException {
        this.cacheTemplate.getCacheService().clearAll();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"[CACHE] All scopes are cleared.");
        }
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void clearScope(@RequestParam(value="contextId") String contextId) throws InvalidContextException, CacheException {
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        this.cacheTemplate.getCacheService().clearScope(context);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[CACHE] Scope for context " + context + " is cleared."));
        }
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void removeItem(@RequestParam(value="contextId") String contextId, @RequestParam(value="url") String url) throws InvalidContextException, CacheException {
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        CacheService cacheService = this.cacheTemplate.getCacheService();
        cacheService.remove(context, this.cacheTemplate.getKey(context, url, "contentStoreAdapter.content"));
        cacheService.remove(context, this.cacheTemplate.getKey(context, url, true, "contentStoreAdapter.item"));
        cacheService.remove(context, this.cacheTemplate.getKey(context, url, false, "contentStoreAdapter.item"));
        cacheService.remove(context, this.cacheTemplate.getKey(context, url, true, "contentStoreAdapter.items"));
        cacheService.remove(context, this.cacheTemplate.getKey(context, url, false, "contentStoreAdapter.items"));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[CACHE] removed " + url + " from scope for context " + context));
        }
    }
}

