/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.core.controller.rest.RestControllerBase;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/api/1/content_store"})
public class ContentStoreRestController
extends RestControllerBase
implements ApplicationContextAware {
    public static final String URL_ROOT = "/content_store";
    public static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    public static final String MUST_REVALIDATE_HEADER_VALUE = "must-revalidate";
    public static final String REQUEST_PARAM_STORE_TYPE = "storeType";
    public static final String REQUEST_PARAM_STORE_SERVER_URL = "storeServerUrl";
    public static final String REQUEST_PARAM_USERNAME = "username";
    public static final String REQUEST_PARAM_PASSWORD = "password";
    public static final String REQUEST_PARAM_ROOT_FOLDER_PATH = "rootFolderPath";
    public static final String REQUEST_PARAM_CACHE_ON = "cacheOn";
    public static final String REQUEST_PARAM_MAX_ALLOWED_ITEMS_IN_CACHE = "maxAllowedItemsInCache";
    public static final String REQUEST_PARAM_IGNORE_HIDDEN_FILES = "ignoreHiddenFiles";
    public static final String REQUEST_PARAM_CONTEXT_ID = "contextId";
    public static final String REQUEST_PARAM_DO_CACHING = "doCaching";
    public static final String REQUEST_PARAM_EXPIRE_AFTER = "expireAfter";
    public static final String REQUEST_PARAM_REFRESH_FREQUENCY = "refreshFrequency";
    public static final String REQUEST_PARAM_URL = "url";
    public static final String REQUEST_PARAM_FILTER = "filter";
    public static final String REQUEST_PARAM_PROCESSOR = "processor";
    public static final String REQUEST_PARAM_TREE_DEPTH = "depth";
    public static final String URL_CREATE_CONTEXT = "/create_context";
    public static final String URL_DESTROY_CONTEXT = "/destroy_context";
    public static final String URL_DESCRIPTOR = "/descriptor";
    public static final String URL_ITEM = "/item";
    public static final String URL_CHILDREN = "/children";
    public static final String URL_TREE = "/tree";
    public static final String MODEL_ATTR_CONTEXT_ID = "contextId";
    public static final String MODEL_ATTR_DESCRIPTOR = "descriptor";
    public static final String MODEL_ATTR_ITEM = "item";
    public static final String MODEL_ATTR_CHILDREN = "children";
    public static final String MODEL_ATTR_TREE = "tree";
    private ContentStoreService storeService;
    private ApplicationContext applicationContext;

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @RequestMapping(value={"/create_context"}, method={RequestMethod.GET})
    public ModelAndView createContext(@RequestParam(value="storeType") String storeType, @RequestParam(value="storeServerUrl") String storeServerUrl, @RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="rootFolderPath") String rootFolderPath, @RequestParam(value="cacheOn") boolean cacheOn, @RequestParam(value="maxAllowedItemsInCache") int maxAllowedItemsInCache, @RequestParam(value="ignoreHiddenFiles") boolean ignoreHiddenFiles) throws StoreException, AuthenticationException {
        Context context = this.storeService.createContext(storeType, storeServerUrl, username, password, rootFolderPath, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        return new ModelAndView("crafter.restView", "contextId", (Object)context.getId());
    }

    @RequestMapping(value={"/destroy_context"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void destroyContext(@RequestParam(value="contextId") String contextId) throws InvalidContextException, StoreException, AuthenticationException {
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        this.storeService.destroyContext(context);
    }

    @RequestMapping(value={"/descriptor"}, method={RequestMethod.GET})
    public ModelAndView getDescriptor(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="doCaching", required=false) Boolean doCaching, @RequestParam(value="expireAfter", required=false) Long expireAfter, @RequestParam(value="refreshFrequency", required=false) Long refreshFrequency, @RequestParam(value="url") String url, @RequestParam(value="processor", required=false) String processor) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        ModelAndView modelAndView = this.getItem(request, response, contextId, doCaching, expireAfter, refreshFrequency, url, processor);
        ModelMap modelMap = modelAndView.getModelMap();
        if (MapUtils.isNotEmpty((Map)modelMap)) {
            Item item = (Item)modelMap.remove((Object)MODEL_ATTR_ITEM);
            modelMap.put((Object)MODEL_ATTR_DESCRIPTOR, (Object)item.getDescriptorDom());
        }
        return modelAndView;
    }

    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    public ModelAndView getItem(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="doCaching", required=false) Boolean doCaching, @RequestParam(value="expireAfter", required=false) Long expireAfter, @RequestParam(value="refreshFrequency", required=false) Long refreshFrequency, @RequestParam(value="url") String url, @RequestParam(value="processor", required=false) String processor) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Item item;
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        CachingOptions cachingOptions = new CachingOptions();
        if (doCaching != null) {
            cachingOptions.setDoCaching(doCaching);
        }
        if (expireAfter != null) {
            cachingOptions.setExpireAfter(expireAfter);
        }
        if (refreshFrequency != null) {
            cachingOptions.setRefreshFrequency(refreshFrequency);
        }
        if ((item = this.storeService.getItem(context, cachingOptions, url, this.getProcessor(processor))).getCachingTime() != null && this.checkNotModified(item.getCachingTime(), request, response)) {
            return new ModelAndView("crafter.restView");
        }
        return new ModelAndView("crafter.restView", MODEL_ATTR_ITEM, (Object)item);
    }

    @RequestMapping(value={"/children"}, method={RequestMethod.GET})
    public ModelAndView getChildren(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="doCaching", required=false) Boolean doCaching, @RequestParam(value="expireAfter", required=false) Long expireAfter, @RequestParam(value="refreshFrequency", required=false) Long refreshFrequency, @RequestParam(value="url") String url, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="processor", required=false) String processor) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        CachingAwareList children;
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new InvalidContextException("No context found for ID " + contextId);
        }
        CachingOptions cachingOptions = new CachingOptions();
        if (doCaching != null) {
            cachingOptions.setDoCaching(doCaching);
        }
        if (expireAfter != null) {
            cachingOptions.setExpireAfter(expireAfter);
        }
        if (refreshFrequency != null) {
            cachingOptions.setRefreshFrequency(refreshFrequency);
        }
        if ((children = (CachingAwareList)this.storeService.getChildren(context, cachingOptions, url, this.getFilter(filter), this.getProcessor(processor))).getCachingTime() != null && this.checkNotModified(children.getCachingTime(), request, response)) {
            return new ModelAndView("crafter.restView");
        }
        return new ModelAndView("crafter.restView", MODEL_ATTR_CHILDREN, new ArrayList(children));
    }

    @RequestMapping(value={"/tree"}, method={RequestMethod.GET})
    public ModelAndView getTree(WebRequest request, HttpServletResponse response, @RequestParam(value="contextId") String contextId, @RequestParam(value="doCaching", required=false) Boolean doCaching, @RequestParam(value="expireAfter", required=false) Long expireAfter, @RequestParam(value="refreshFrequency", required=false) Long refreshFrequency, @RequestParam(value="url") String url, @RequestParam(value="depth", required=false) Integer depth, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="processor", required=false) String processor) throws InvalidContextException, StoreException, PathNotFoundException, ItemProcessingException, XmlMergeException, XmlFileParseException {
        Tree tree;
        Context context = this.storeService.getContext(contextId);
        if (context == null) {
            throw new IllegalArgumentException("No context found for ID " + contextId);
        }
        CachingOptions cachingOptions = new CachingOptions();
        if (doCaching != null) {
            cachingOptions.setDoCaching(doCaching);
        }
        if (expireAfter != null) {
            cachingOptions.setExpireAfter(expireAfter);
        }
        if (refreshFrequency != null) {
            cachingOptions.setRefreshFrequency(refreshFrequency);
        }
        if ((tree = this.storeService.getTree(context, cachingOptions, url, depth != null ? depth : -1, this.getFilter(filter), this.getProcessor(processor))).getCachingTime() != null && this.checkNotModified(tree.getCachingTime(), request, response)) {
            return new ModelAndView("crafter.restView");
        }
        return new ModelAndView("crafter.restView", MODEL_ATTR_TREE, (Object)tree);
    }

    private boolean checkNotModified(long lastModifiedTimestamp, WebRequest request, HttpServletResponse response) {
        response.setHeader(CACHE_CONTROL_HEADER_NAME, MUST_REVALIDATE_HEADER_VALUE);
        return request.checkNotModified(lastModifiedTimestamp);
    }

    private ItemFilter getFilter(String filterName) {
        if (StringUtils.isNotEmpty((String)filterName)) {
            return (ItemFilter)this.applicationContext.getBean(filterName, ItemFilter.class);
        }
        return null;
    }

    private ItemProcessor getProcessor(String processorName) {
        if (StringUtils.isNotEmpty((String)processorName)) {
            return (ItemProcessor)this.applicationContext.getBean(processorName, ItemProcessor.class);
        }
        return null;
    }
}

