/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.controller.rest;

import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.PathNotFoundException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

public class RestControllerBase {
    public static final String REST_BASE_URI = "/api/1";
    public static final String EXCEPTION_MODEL_ATTRIBUTE_NAME = "exception";
    public static final String REST_VIEW_NAME = "crafter.restView";

    @ExceptionHandler(value={InvalidContextException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ModelAndView handleInvalidContextException(InvalidContextException e) {
        return this.handleException(e);
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ModelAndView handleAuthenticationException(AuthenticationException e) {
        return this.handleException(e);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ModelAndView handlePathNotFoundException(PathNotFoundException e) {
        return this.handleException(e);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ModelAndView handleException(Exception e) {
        return new ModelAndView(REST_VIEW_NAME, EXCEPTION_MODEL_ATTRIBUTE_NAME, (Object)e);
    }
}

