/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.UrlUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Required;

public class IncludeDescriptorsProcessor
implements ItemProcessor {
    private static final Log logger = LogFactory.getLog(IncludeDescriptorsProcessor.class);
    protected String includeElementXPathQuery;
    protected ContentStoreService contentStoreService;

    @Required
    public void setIncludeElementXPathQuery(String includeElementXPathQuery) {
        this.includeElementXPathQuery = includeElementXPathQuery;
    }

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        this.includeDescriptors(context, cachingOptions, item);
        return item;
    }

    protected void includeDescriptors(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String descriptorUrl = item.getDescriptorUrl();
        Document descriptorDom = item.getDescriptorDom();
        List includeElements = descriptorDom.selectNodes(this.includeElementXPathQuery);
        if (CollectionUtils.isEmpty((Collection)includeElements)) {
            return;
        }
        for (Element includeElement : includeElements) {
            String includeSrcPath = includeElement.getTextTrim();
            if (StringUtils.isEmpty((String)includeSrcPath)) {
                throw new ItemProcessingException("No path provided in the <" + includeElement.getName() + "> element");
            }
            includeSrcPath = this.fromRelativeToAbsoluteUrl(descriptorUrl, includeSrcPath);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Include found in " + descriptorUrl + ": " + includeSrcPath));
            }
            Item includeSrcItem = this.getIncludeSrcItem(context, cachingOptions, includeSrcPath);
            this.doInclude(includeElement, includeSrcPath, includeSrcItem.getDescriptorDom());
            item.addDependencyKey(includeSrcItem.getKey());
        }
    }

    protected String fromRelativeToAbsoluteUrl(String descriptorUrl, String includeSrcPath) throws ItemProcessingException {
        try {
            return UrlUtils.resolveRelative(descriptorUrl, includeSrcPath);
        }
        catch (URISyntaxException e) {
            throw new ItemProcessingException("Invalid relative URL " + includeSrcPath, e);
        }
    }

    protected Item getIncludeSrcItem(Context context, CachingOptions cachingOptions, String includeSrcPath) throws ItemProcessingException {
        try {
            return this.contentStoreService.getItem(context, cachingOptions, includeSrcPath);
        }
        catch (Exception e) {
            throw new ItemProcessingException("Unable to load descriptor " + includeSrcPath + " from the underlying " + "repository", e);
        }
    }

    protected void doInclude(Element includeElement, String includeSrcPath, Document includeSrc) throws ItemProcessingException {
        List includeElementParentChildren = includeElement.getParent().content();
        int includeElementIdx = includeElementParentChildren.indexOf(includeElement);
        Element includeSrcRootElement = includeSrc.getRootElement().createCopy();
        includeElementParentChildren.remove(includeElementIdx);
        includeElementParentChildren.add(includeElementIdx, includeSrcRootElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncludeDescriptorsProcessor that = (IncludeDescriptorsProcessor)o;
        if (!this.includeElementXPathQuery.equals(that.includeElementXPathQuery)) {
            return false;
        }
        return this.contentStoreService.equals(that.contentStoreService);
    }

    public int hashCode() {
        int result = this.includeElementXPathQuery.hashCode();
        result = 31 * result + this.contentStoreService.hashCode();
        return result;
    }

    public String toString() {
        return "IncludeDescriptorsProcessor[contentStoreService=" + this.contentStoreService + ", includeElementXPathQuery='" + this.includeElementXPathQuery + '\'' + ']';
    }
}

