/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;

public class ItemProcessorPipeline
implements ItemProcessor {
    protected List<ItemProcessor> processors;

    public ItemProcessorPipeline() {
    }

    public ItemProcessorPipeline(List<ItemProcessor> processors) {
        this.processors = processors;
    }

    public ItemProcessorPipeline(ItemProcessor ... processors) {
        this.processors = Arrays.asList(processors);
    }

    public void addProcessor(ItemProcessor processor) {
        if (this.processors == null) {
            this.processors = new ArrayList<ItemProcessor>();
        }
        this.processors.add(processor);
    }

    public boolean removeProcessor(ItemProcessor processor) {
        if (this.processors != null) {
            return this.processors.remove(processor);
        }
        return false;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        if (CollectionUtils.isNotEmpty(this.processors)) {
            for (ItemProcessor processor : this.processors) {
                item = processor.process(context, cachingOptions, item);
            }
        }
        return item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemProcessorPipeline that = (ItemProcessorPipeline)o;
        return !(this.processors != null ? !this.processors.equals(that.processors) : that.processors != null);
    }

    public int hashCode() {
        return this.processors != null ? this.processors.hashCode() : 0;
    }

    public String toString() {
        return "ItemProcessorPipeline[processors=" + this.processors + ']';
    }
}

