/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.url.UrlTransformationEngine;
import org.springframework.beans.factory.annotation.Required;

public class ItemUrlTransformingProcessor
implements ItemProcessor {
    protected String transformedUrlPropName;
    protected String transformerName;
    protected UrlTransformationEngine urlTransformationEngine;

    @Required
    public void setTransformedUrlPropName(String transformedUrlPropName) {
        this.transformedUrlPropName = transformedUrlPropName;
    }

    @Required
    public void setTransformerName(String transformerName) {
        this.transformerName = transformerName;
    }

    @Required
    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String transformedUrl = this.urlTransformationEngine.transformUrl(context, this.transformerName, item.getUrl());
        item.setProperty(this.transformedUrlPropName, transformedUrl);
        return item;
    }

    public String toString() {
        return "ItemUrlTransformingProcessor[transformedUrlPropName='" + this.transformedUrlPropName + '\'' + ", " + "transformerName='" + this.transformerName + '\'' + ", urlTransformationEngine=" + this.urlTransformationEngine + ']';
    }
}

