/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;

public class TextMetaDataCollectionExtractingProcessor
implements ItemProcessor {
    protected String[] metaDataNodesXPathQueries;

    public TextMetaDataCollectionExtractingProcessor(String ... metaDataNodesXPathQueries) {
        this.metaDataNodesXPathQueries = metaDataNodesXPathQueries;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        for (String xPathQuery : this.metaDataNodesXPathQueries) {
            List<String> metaDataValues = item.queryDescriptorValues(xPathQuery);
            if (!CollectionUtils.isNotEmpty(metaDataValues)) continue;
            item.setProperty(xPathQuery, metaDataValues);
        }
        return item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMetaDataCollectionExtractingProcessor that = (TextMetaDataCollectionExtractingProcessor)o;
        return this.metaDataNodesXPathQueries.equals(that.metaDataNodesXPathQueries);
    }

    public int hashCode() {
        return this.metaDataNodesXPathQueries.hashCode();
    }

    public String toString() {
        return "TextMetaDataCollectionExtractingProcessor[metaDataNodesXPathQueries=" + Arrays.toString(this.metaDataNodesXPathQueries) + ']';
    }
}

