/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;

public class TextMetaDataExtractingProcessor
implements ItemProcessor {
    protected String[] metaDataNodesXPathQueries;

    public TextMetaDataExtractingProcessor(String ... metaDataNodesXPathQueries) {
        this.metaDataNodesXPathQueries = metaDataNodesXPathQueries;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) {
        for (String xPathQuery : this.metaDataNodesXPathQueries) {
            String metaDataValue = item.queryDescriptorValue(xPathQuery);
            if (!StringUtils.isNotEmpty((String)metaDataValue)) continue;
            item.setProperty(xPathQuery, metaDataValue);
        }
        return item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMetaDataExtractingProcessor that = (TextMetaDataExtractingProcessor)o;
        return this.metaDataNodesXPathQueries.equals(that.metaDataNodesXPathQueries);
    }

    public int hashCode() {
        return this.metaDataNodesXPathQueries.hashCode();
    }

    public String toString() {
        return "TextMetaDataExtractingProcessor[metaDataNodesXPathQueries=" + Arrays.toString(this.metaDataNodesXPathQueries) + ']';
    }
}

