/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl.resolvers;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.ItemProcessorResolver;
import org.craftercms.core.service.Item;
import org.springframework.beans.factory.annotation.Required;

public class ItemProcessorResolverChain
implements ItemProcessorResolver {
    protected ItemProcessor defaultProcessor;
    protected List<ItemProcessorResolver> resolvers;

    @Required
    public void setDefaultProcessor(ItemProcessor defaultProcessor) {
        this.defaultProcessor = defaultProcessor;
    }

    @Required
    public void setResolvers(List<ItemProcessorResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ItemProcessor getProcessor(Item item) {
        if (CollectionUtils.isNotEmpty(this.resolvers)) {
            for (ItemProcessorResolver resolver : this.resolvers) {
                ItemProcessor processor = resolver.getProcessor(item);
                if (processor == null) continue;
                return processor;
            }
        }
        return this.defaultProcessor;
    }
}

