/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.processors.impl.template;

import java.io.StringWriter;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.TemplateException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.impl.template.NodeTemplateModelFactory;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.util.template.CompiledTemplate;
import org.craftercms.core.util.template.TemplateCompiler;
import org.craftercms.core.util.template.impl.IdentifiableStringTemplateSource;
import org.craftercms.core.util.xml.NodeScanner;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public class TemplateProcessor
implements ItemProcessor {
    private static final Log logger = LogFactory.getLog(TemplateProcessor.class);
    protected NodeScanner templateNodeScanner;
    protected TemplateCompiler<IdentifiableStringTemplateSource> templateCompiler;
    protected NodeTemplateModelFactory modelFactory;

    @Required
    public void setTemplateNodeScanner(NodeScanner templateNodeScanner) {
        this.templateNodeScanner = templateNodeScanner;
    }

    @Required
    public void setTemplateCompiler(TemplateCompiler<IdentifiableStringTemplateSource> templateCompiler) {
        this.templateCompiler = templateCompiler;
    }

    @Required
    public void setModelFactory(NodeTemplateModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Override
    public Item process(Context context, CachingOptions cachingOptions, Item item) throws ItemProcessingException {
        String descriptorUrl = item.getDescriptorUrl();
        Document descriptorDom = item.getDescriptorDom();
        List<Node> templateNodes = this.templateNodeScanner.scan(descriptorDom);
        if (CollectionUtils.isNotEmpty(templateNodes)) {
            for (Node templateNode : templateNodes) {
                String templateNodePath = templateNode.getUniquePath();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Template found in " + descriptorUrl + " at " + templateNodePath));
                }
                String templateId = templateNodePath + "@" + descriptorUrl;
                String template = templateNode.getText();
                IdentifiableStringTemplateSource templateSource = new IdentifiableStringTemplateSource(templateId, template);
                Object model = this.modelFactory.getModel(item, templateNode, template);
                StringWriter output = new StringWriter();
                try {
                    CompiledTemplate compiledTemplate = this.templateCompiler.compile(templateSource);
                    compiledTemplate.process(model, output);
                }
                catch (TemplateException e) {
                    throw new ItemProcessingException("Unable to process the template " + templateId, e);
                }
                templateNode.setText(output.toString());
            }
        }
        return item;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateProcessor that = (TemplateProcessor)o;
        if (!this.modelFactory.equals(that.modelFactory)) {
            return false;
        }
        if (!this.templateCompiler.equals(that.templateCompiler)) {
            return false;
        }
        return this.templateNodeScanner.equals(that.templateNodeScanner);
    }

    public int hashCode() {
        int result = this.templateNodeScanner.hashCode();
        result = 31 * result + this.templateCompiler.hashCode();
        result = 31 * result + this.modelFactory.hashCode();
        return result;
    }

    public String toString() {
        return "TemplateProcessor[modelFactory=" + this.modelFactory + ", templateNodeScanner=" + this.templateNodeScanner + ", templateCompiler=" + this.templateCompiler + ']';
    }
}

