/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.List;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.cache.CacheCallback;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractCachedContentStoreService
implements ContentStoreService {
    public static final String CONST_KEY_ELEM_ITEM = "contentStoreService.item";
    public static final String CONST_KEY_ELEM_CHILDREN = "contentStoreService.children";
    public static final String CONST_KEY_ELEM_TREE = "contentStoreService.tree";
    protected CacheTemplate cacheTemplate;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Override
    public Item getItem(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getItem(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, null);
    }

    @Override
    public Item getItem(Context context, CachingOptions cachingOptions, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getItem(context, cachingOptions, url, null);
    }

    @Override
    public Item getItem(Context context, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getItem(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, processor);
    }

    @Override
    public Item getItem(final Context context, final CachingOptions cachingOptions, final String url, final ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.cacheTemplate.execute(context, cachingOptions, new CacheCallback<Item>(){

            @Override
            public Item doCacheable() {
                return AbstractCachedContentStoreService.this.doGetItem(context, cachingOptions, url, processor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getItem(%s, %s, " + "" + "%s)", context, url, processor);
            }
        }, context, url, processor, CONST_KEY_ELEM_ITEM);
    }

    @Override
    public List<Item> getChildren(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, null, null);
    }

    @Override
    public List<Item> getChildren(Context context, CachingOptions cachingOptions, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, cachingOptions, url, null, null);
    }

    @Override
    public List<Item> getChildren(Context context, String url, ItemFilter filter) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, filter, null);
    }

    @Override
    public List<Item> getChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, cachingOptions, url, filter, null);
    }

    @Override
    public List<Item> getChildren(Context context, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, null, processor);
    }

    @Override
    public List<Item> getChildren(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, cachingOptions, url, null, processor);
    }

    @Override
    public List<Item> getChildren(Context context, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getChildren(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, filter, processor);
    }

    @Override
    public List<Item> getChildren(final Context context, final CachingOptions cachingOptions, final String url, final ItemFilter filter, final ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.cacheTemplate.execute(context, cachingOptions, new CacheCallback<List<Item>>(){

            @Override
            public List<Item> doCacheable() {
                List<Item> children = AbstractCachedContentStoreService.this.doGetChildren(context, cachingOptions, url, filter, processor);
                if (children instanceof CachingAwareList) {
                    return children;
                }
                return new CachingAwareList<Item>(children);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getChildren(%s, " + "" + "%s, %s, %s)", context, url, filter, processor);
            }
        }, context, url, filter, processor, CONST_KEY_ELEM_CHILDREN);
    }

    @Override
    public Tree getTree(Context context, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, -1, null, null);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, -1, null, null);
    }

    @Override
    public Tree getTree(Context context, String url, int depth) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, depth, null, null);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, int depth) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, depth, null, null);
    }

    @Override
    public Tree getTree(Context context, String url, ItemFilter filter) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, -1, filter, null);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, ItemFilter filter) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, -1, filter, null);
    }

    @Override
    public Tree getTree(Context context, String url, int depth, ItemFilter filter) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, depth, filter, null);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, depth, filter, null);
    }

    @Override
    public Tree getTree(Context context, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, -1, null, processor);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, -1, null, processor);
    }

    @Override
    public Tree getTree(Context context, String url, int depth, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, depth, null, processor);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, depth, null, processor);
    }

    @Override
    public Tree getTree(Context context, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, -1, filter, processor);
    }

    @Override
    public Tree getTree(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, cachingOptions, url, -1, filter, processor);
    }

    @Override
    public Tree getTree(Context context, String url, int depth, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.getTree(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url, depth, filter, processor);
    }

    @Override
    public Tree getTree(final Context context, final CachingOptions cachingOptions, final String url, final int depth, final ItemFilter filter, final ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        return this.cacheTemplate.execute(context, cachingOptions, new CacheCallback<Tree>(){

            @Override
            public Tree doCacheable() {
                return AbstractCachedContentStoreService.this.doGetTree(context, cachingOptions, url, depth, filter, processor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreService.this.getClass().getName() + ".getTree(%s, %s, " + "" + "%d, %s, %s)", context, url, depth, filter, processor);
            }
        }, context, url, depth, filter, processor, CONST_KEY_ELEM_TREE);
    }

    protected abstract Item doGetItem(Context var1, CachingOptions var2, String var3, ItemProcessor var4) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    protected abstract List<Item> doGetChildren(Context var1, CachingOptions var2, String var3, ItemFilter var4, ItemProcessor var5) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;

    protected abstract Tree doGetTree(Context var1, CachingOptions var2, String var3, int var4, ItemFilter var5, ItemProcessor var6) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException;
}

