/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;

public class CompositeItemFilter
implements ItemFilter {
    private List<ItemFilter> filters;

    public CompositeItemFilter() {
    }

    public CompositeItemFilter(List<ItemFilter> filters) {
        this.filters = filters;
    }

    public CompositeItemFilter(ItemFilter ... filters) {
        this.filters = Arrays.asList(filters);
    }

    public void addFilter(ItemFilter filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<ItemFilter>();
        }
        this.filters.add(filter);
    }

    public boolean removeFilter(ItemFilter filter) {
        if (this.filters != null) {
            return this.filters.remove(filter);
        }
        return false;
    }

    @Override
    public boolean runBeforeProcessing() {
        return true;
    }

    @Override
    public boolean runAfterProcessing() {
        return true;
    }

    @Override
    public boolean accepts(Item item, boolean runningBeforeProcessing) {
        boolean accepted = true;
        if (CollectionUtils.isNotEmpty(this.filters)) {
            Iterator<ItemFilter> filterIter = this.filters.iterator();
            while (accepted && filterIter.hasNext()) {
                ItemFilter filter = filterIter.next();
                if (runningBeforeProcessing && filter.runBeforeProcessing()) {
                    accepted = filter.accepts(item, runningBeforeProcessing);
                    continue;
                }
                if (runningBeforeProcessing || !filter.runAfterProcessing()) continue;
                accepted = filter.accepts(item, runningBeforeProcessing);
            }
        }
        return accepted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeItemFilter that = (CompositeItemFilter)o;
        return !(this.filters != null ? !this.filters.equals(that.filters) : that.filters != null);
    }

    public int hashCode() {
        return this.filters != null ? this.filters.hashCode() : 0;
    }

    public String toString() {
        return "CompositeItemFilter[filters=" + this.filters + ']';
    }
}

