/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.exception.InvalidStoreTypeException;
import org.craftercms.core.exception.ItemProcessingException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.exception.XmlMergeException;
import org.craftercms.core.processors.ItemProcessor;
import org.craftercms.core.processors.ItemProcessorResolver;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.service.impl.AbstractCachedContentStoreService;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.store.ContentStoreAdapterRegistry;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategy;
import org.craftercms.core.xml.mergers.DescriptorMergeStrategyResolver;
import org.craftercms.core.xml.mergers.DescriptorMerger;
import org.craftercms.core.xml.mergers.MergeableDescriptor;
import org.dom4j.Document;
import org.springframework.beans.factory.annotation.Required;

public class ContentStoreServiceImpl
extends AbstractCachedContentStoreService {
    private static final Log logger = LogFactory.getLog(ContentStoreServiceImpl.class);
    private ContentStoreAdapterRegistry storeAdapterRegistry;
    private DescriptorMergeStrategyResolver mergeStrategyResolver;
    private DescriptorMerger merger;
    private ItemProcessorResolver processorResolver;
    private Map<String, Context> contexts = new ConcurrentHashMap<String, Context>();

    @Required
    public void setStoreAdapterRegistry(ContentStoreAdapterRegistry storeAdapterRegistry) {
        this.storeAdapterRegistry = storeAdapterRegistry;
    }

    @Required
    public void setMergeStrategyResolver(DescriptorMergeStrategyResolver mergeStrategyResolver) {
        this.mergeStrategyResolver = mergeStrategyResolver;
    }

    @Required
    public void setMerger(DescriptorMerger merger) {
        this.merger = merger;
    }

    @Required
    public void setProcessorResolver(ItemProcessorResolver processorResolver) {
        this.processorResolver = processorResolver;
    }

    @Override
    public Context getContext(String contextId) {
        return this.contexts.get(contextId);
    }

    @Override
    public Context createContext(String storeType, String storeServerUrl, String username, String password, String rootFolderPath, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws InvalidStoreTypeException, StoreException, AuthenticationException {
        String id = this.createContextId(storeType, storeServerUrl, username, password, rootFolderPath, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        if (!this.contexts.containsKey(id)) {
            ContentStoreAdapter storeAdapter = (ContentStoreAdapter)this.storeAdapterRegistry.get(storeType);
            if (storeAdapter == null) {
                throw new InvalidStoreTypeException("No registered content store adapter for store type " + storeType);
            }
            Context context = storeAdapter.createContext(id, storeServerUrl, username, password, rootFolderPath, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
            this.cacheTemplate.getCacheService().addScope(context);
            this.contexts.put(id, context);
            return context;
        }
        throw new StoreException("A context for id '" + id + "' already exists");
    }

    @Override
    public void destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
        if (!this.contexts.containsKey(context.getId())) {
            throw new InvalidContextException("Context " + context + " is not valid");
        }
        context.getStoreAdapter().destroyContext(context);
        this.cacheTemplate.getCacheService().removeScope(context);
        this.contexts.remove(context.getId());
    }

    @Override
    public Content getContent(Context context, String url) throws InvalidScopeException, PathNotFoundException, StoreException {
        return this.getContent(context, CachingOptions.DEFAULT_CACHING_OPTIONS, url);
    }

    @Override
    public Content getContent(Context context, CachingOptions cachingOptions, String url) throws InvalidScopeException, PathNotFoundException, StoreException {
        return context.getStoreAdapter().getContent(context, cachingOptions, url);
    }

    @Override
    protected Item doGetItem(Context context, CachingOptions cachingOptions, String url, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        Item item;
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        if ((item = new Item(context.getStoreAdapter().getItem(context, cachingOptions, url, true))).getDescriptorDom() != null) {
            item = this.doMerging(context, cachingOptions, item);
            item = this.doProcessing(context, cachingOptions, item, processor);
        } else {
            item.addDependencyKey(item.getKey());
        }
        return item;
    }

    @Override
    protected List<Item> doGetChildren(Context context, CachingOptions cachingOptions, String url, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return this.doGetChildren(context, cachingOptions, url, null, filter, processor);
    }

    @Override
    protected Tree doGetTree(Context context, CachingOptions cachingOptions, String url, int depth, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        Tree tree = new Tree(this.getItem(context, url, processor));
        if (depth == -1 || depth >= 1) {
            if (depth >= 1) {
                --depth;
            }
            CachingAwareList treeChildren = (CachingAwareList)this.doGetChildren(context, cachingOptions, url, depth, filter, processor);
            tree.setChildren(treeChildren.getActualList());
            tree.addDependencyKeys(treeChildren.getDependencyKeys());
        }
        return tree;
    }

    protected List<Item> doGetChildren(Context context, CachingOptions cachingOptions, String url, Integer depth, ItemFilter filter, ItemProcessor processor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, XmlMergeException, ItemProcessingException, StoreException {
        ArrayList<Object> dependencyKeys = new ArrayList<Object>();
        List<Item> children = context.getStoreAdapter().getItems(context, cachingOptions, url, false);
        dependencyKeys.add(((CachingAwareList)children).getKey());
        if (filter != null && filter.runBeforeProcessing()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Running filter " + filter + " before processing for " + url + "..."));
            }
            children = this.doFilter(children, filter, true);
        }
        List<Item> processedChildren = new ArrayList<Item>(children.size());
        for (Item child : children) {
            Item processedChild = depth != null && child.isFolder() ? this.getTree(context, child.getUrl(), depth, filter, processor) : this.getItem(context, child.getUrl(), processor);
            processedChildren.add(processedChild);
        }
        if (filter != null && filter.runAfterProcessing()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Running filter " + filter + " after processing for " + url + "..."));
            }
            processedChildren = this.doFilter(processedChildren, filter, false);
        }
        Collections.sort(processedChildren, CompareByItemUrlComparator.instance);
        for (Item child : processedChildren) {
            dependencyKeys.add(child.getKey());
        }
        CachingAwareList<Item> finalChildren = new CachingAwareList<Item>(processedChildren);
        finalChildren.setDependencyKeys(dependencyKeys);
        return finalChildren;
    }

    protected Item doMerging(Context context, CachingOptions cachingOptions, Item item) throws CrafterException {
        List<MergeableDescriptor> descriptorsToMerge;
        String descriptorUrl;
        DescriptorMergeStrategy strategy;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Doing merge for " + item + "..."));
        }
        if ((strategy = this.mergeStrategyResolver.getStrategy(descriptorUrl = item.getDescriptorUrl(), item.getDescriptorDom())) == null) {
            logger.warn((Object)("No merge strategy was found for " + descriptorUrl + ". Merging skipped"));
            return item;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Merge strategy for " + descriptorUrl + ": " + strategy));
        }
        if ((descriptorsToMerge = strategy.getDescriptors(context, cachingOptions, descriptorUrl)) == null) {
            throw new XmlMergeException("There aren't any descriptors to merge for " + descriptorUrl);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Descriptors to merge for " + descriptorUrl + ": " + descriptorsToMerge));
        }
        ArrayList<Document> documentsToMerge = new ArrayList<Document>(descriptorsToMerge.size());
        for (MergeableDescriptor descriptorToMerge : descriptorsToMerge) {
            try {
                Item descriptorItem = context.getStoreAdapter().getItem(context, cachingOptions, descriptorToMerge.getUrl(), true);
                Document descriptorDom = descriptorItem.getDescriptorDom();
                if (descriptorDom == null) {
                    throw new PathNotFoundException("No descriptor file at " + item.getDescriptorUrl());
                }
                documentsToMerge.add(descriptorDom);
                item.addDependencyKey(descriptorItem.getKey());
            }
            catch (PathNotFoundException e) {
                if (descriptorToMerge.isOptional()) continue;
                throw new XmlMergeException("Descriptor file " + descriptorToMerge.getUrl() + " not found and is " + "marked as " + "required for merging");
            }
        }
        Document mergedDoc = this.merger.merge(documentsToMerge);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Merged descriptor DOM for " + item + ":\n" + XmlUtils.documentToPrettyString(mergedDoc)));
        }
        item.setDescriptorDom(mergedDoc);
        return item;
    }

    protected Item doProcessing(Context context, CachingOptions cachingOptions, Item item, ItemProcessor additionalProcessor) throws ItemProcessingException {
        ItemProcessor mainProcessor;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Doing processing for " + item + "..."));
        }
        if ((mainProcessor = this.processorResolver.getProcessor(item)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Main processor found for " + item + ": " + mainProcessor));
            }
            item = mainProcessor.process(context, cachingOptions, item);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No main processor was found for " + item));
        }
        if (additionalProcessor != null) {
            item = additionalProcessor.process(context, cachingOptions, item);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processed item: " + item));
            logger.debug((Object)("Processed descriptor DOM for " + item + ":\n" + XmlUtils.documentToPrettyString(item.getDescriptorDom())));
        }
        return item;
    }

    protected List<Item> doFilter(List<Item> items, ItemFilter filter, boolean runningBeforeProcessing) {
        ArrayList<Item> filteredItems = new ArrayList<Item>();
        for (Item item : items) {
            if (!filter.accepts(item, runningBeforeProcessing)) continue;
            filteredItems.add(item);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Items filtered from " + items + " by " + filter + ": " + filteredItems));
        }
        return filteredItems;
    }

    protected String createContextId(String storeType, String storeServerUrl, String username, String password, String rootFolderPath, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) {
        String unHashedId = "storeType='" + storeType + '\'' + ", storeServerUrl='" + storeServerUrl + '\'' + ", username='" + username + '\'' + ", password='" + password + '\'' + ", rootFolderPath='" + rootFolderPath + '\'' + ", cacheOn=" + cacheOn + ", maxAllowedItemsInCache=" + maxAllowedItemsInCache + ", ignoreHiddenFiles=" + ignoreHiddenFiles;
        return DigestUtils.md5Hex((String)unHashedId);
    }

    private static class CompareByItemUrlComparator
    implements Comparator<Item> {
        public static final CompareByItemUrlComparator instance = new CompareByItemUrlComparator();

        private CompareByItemUrlComparator() {
        }

        @Override
        public int compare(Item item1, Item item2) {
            return item1.getUrl().compareTo(item2.getUrl());
        }
    }
}

