/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl;

import java.util.List;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.InvalidScopeException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.store.ContentStoreAdapter;
import org.craftercms.core.util.cache.CacheCallback;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractCachedContentStoreAdapter
implements ContentStoreAdapter {
    public static final String CONST_KEY_ELEM_CONTENT = "contentStoreAdapter.content";
    public static final String CONST_KEY_ELEM_ITEM = "contentStoreAdapter.item";
    public static final String CONST_KEY_ELEM_ITEMS = "contentStoreAdapter.items";
    protected CacheTemplate cacheTemplate;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    @Override
    public Content getContent(final Context context, final CachingOptions cachingOptions, final String path) throws InvalidScopeException, PathNotFoundException, StoreException {
        return this.cacheTemplate.execute(context, cachingOptions, new CacheCallback<Content>(){

            @Override
            public Content doCacheable() {
                return AbstractCachedContentStoreAdapter.this.doGetContent(context, cachingOptions, path);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".doGetContent(%s," + " %s)", context, path);
            }
        }, context, path, CONST_KEY_ELEM_CONTENT);
    }

    @Override
    public Item getItem(final Context context, final CachingOptions cachingOptions, final String path, final boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        return this.cacheTemplate.execute(context, cachingOptions, new CacheCallback<Item>(){

            @Override
            public Item doCacheable() {
                return AbstractCachedContentStoreAdapter.this.doGetItem(context, cachingOptions, path, withDescriptor);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".doGetItem(%s, " + "%s, %s)", context, path, withDescriptor);
            }
        }, context, path, withDescriptor, CONST_KEY_ELEM_ITEM);
    }

    @Override
    public List<Item> getItems(final Context context, final CachingOptions cachingOptions, final String path, final boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        return this.cacheTemplate.execute(context, cachingOptions, new CacheCallback<List<Item>>(){

            @Override
            public List<Item> doCacheable() {
                List<Item> items = AbstractCachedContentStoreAdapter.this.doGetItems(context, cachingOptions, path, withDescriptor);
                if (items instanceof CachingAwareList) {
                    return items;
                }
                return new CachingAwareList<Item>(items);
            }

            public String toString() {
                return String.format(AbstractCachedContentStoreAdapter.this.getClass().getName() + ".doGetItems(%s, " + "%s, %s)", context, path, withDescriptor);
            }
        }, context, path, withDescriptor, CONST_KEY_ELEM_ITEMS);
    }

    protected abstract Content doGetContent(Context var1, CachingOptions var2, String var3) throws InvalidContextException, PathNotFoundException, StoreException;

    protected abstract Item doGetItem(Context var1, CachingOptions var2, String var3, boolean var4) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException;

    protected abstract List<Item> doGetItems(Context var1, CachingOptions var2, String var3, boolean var4) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException;
}

