/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.exception.XmlFileParseException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.Context;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.impl.CachedContent;
import org.craftercms.core.store.impl.AbstractCachedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.util.CollectionUtils;
import org.craftercms.core.util.cache.impl.CachingAwareList;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractFileBasedContentStoreAdapter
extends AbstractCachedContentStoreAdapter {
    private static final Log logger = LogFactory.getLog(AbstractFileBasedContentStoreAdapter.class);
    private String descriptorFileExtension;
    private String metadataFileExtension;

    @Required
    public void setDescriptorFileExtension(String descriptorFileExtension) {
        this.descriptorFileExtension = descriptorFileExtension;
    }

    @Required
    public void setMetadataFileExtension(String metadataFileExtension) {
        this.metadataFileExtension = metadataFileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Content doGetContent(Context context, CachingOptions cachingOptions, String path) throws InvalidContextException, PathNotFoundException, StoreException {
        File file = this.getFile(context, path = this.normalizePath(path));
        if (!file.isFile()) {
            throw new StoreException("Unable to get content: " + file + " is not a file");
        }
        if (context.isCacheOn() && cachingOptions.doCaching()) {
            CachedContent cachedContent;
            InputStream fileInputStream = file.getInputStream();
            try {
                cachedContent = new CachedContent(IOUtils.toByteArray((InputStream)fileInputStream), file.getLastModified());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)("Unable to close input stream for file at " + file), (Throwable)e);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new StoreException("Unable to open input stream for file at " + file, e);
                }
            }
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                logger.warn((Object)("Unable to close input stream for file at " + file), (Throwable)e);
            }
            return cachedContent;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Item doGetItem(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        path = this.normalizePath(path);
        File file = this.getFile(context, path);
        Item item = new Item();
        item.setName(file.getName());
        item.setUrl(path);
        item.setFolder(file.isDirectory());
        if (withDescriptor) {
            File descriptorFile;
            if (file.isFile() && item.getName().endsWith(this.descriptorFileExtension)) {
                item.setDescriptorUrl(path);
                descriptorFile = file;
            } else {
                String descriptorPath = FilenameUtils.removeExtension((String)path) + this.metadataFileExtension;
                item.setDescriptorUrl(descriptorPath);
                try {
                    descriptorFile = this.getFile(context, descriptorPath);
                    if (!descriptorFile.isFile()) {
                        throw new StoreException("Descriptor file at " + descriptorFile + " is not really a file");
                    }
                }
                catch (PathNotFoundException e) {
                    descriptorFile = null;
                }
            }
            if (descriptorFile != null) {
                try {
                    BufferedInputStream fileInputStream = new BufferedInputStream(descriptorFile.getInputStream());
                    try {
                        item.setDescriptorDom(this.createXmlReader().read((InputStream)fileInputStream));
                    }
                    finally {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException e) {
                            logger.warn((Object)("Unable to close input stream for descriptor file at " + descriptorFile), (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    throw new StoreException("Unable to open input stream for descriptor file at " + descriptorFile, e);
                }
                catch (DocumentException e) {
                    throw new XmlFileParseException("Error while parsing xml document at " + descriptorFile, e);
                }
            }
        }
        return item;
    }

    @Override
    protected List<Item> doGetItems(Context context, CachingOptions cachingOptions, String path, boolean withDescriptor) throws InvalidContextException, PathNotFoundException, XmlFileParseException, StoreException {
        File dir = this.getFile(context, path = this.normalizePath(path));
        if (!dir.isDirectory()) {
            throw new StoreException("The path " + dir + " doesn't correspond to a dir");
        }
        List<File> children = this.getChildren(context, dir);
        CachingAwareList<Item> items = new CachingAwareList<Item>(children.size());
        if (CollectionUtils.isNotEmpty(children)) {
            for (File child : children) {
                if (child.isFile() && child.getName().endsWith(this.metadataFileExtension)) continue;
                String fileRelPath = path + (!path.equals("/") ? "/" : "") + child.getName();
                Item item = this.getItem(context, cachingOptions, fileRelPath, withDescriptor);
                items.add(item);
                items.addDependencyKey(item.getKey());
            }
        }
        return items;
    }

    protected String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.equals("/")) {
            path = StringUtils.stripEnd((String)path, (String)"/");
        }
        return path;
    }

    protected SAXReader createXmlReader() {
        SAXReader xmlReader = new SAXReader();
        xmlReader.setMergeAdjacentText(true);
        xmlReader.setStripWhitespaceText(true);
        xmlReader.setIgnoreComments(true);
        return xmlReader;
    }

    protected abstract File getFile(Context var1, String var2) throws InvalidContextException, PathNotFoundException, StoreException;

    protected abstract List<File> getChildren(Context var1, File var2) throws InvalidContextException, PathNotFoundException, StoreException;
}

