/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.store.impl.filesystem;

import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.craftercms.core.exception.AuthenticationException;
import org.craftercms.core.exception.InvalidContextException;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.exception.StoreException;
import org.craftercms.core.service.Context;
import org.craftercms.core.store.impl.AbstractFileBasedContentStoreAdapter;
import org.craftercms.core.store.impl.File;
import org.craftercms.core.store.impl.filesystem.FileSystemContext;
import org.craftercms.core.store.impl.filesystem.FileSystemFile;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class FileSystemContentStoreAdapter
extends AbstractFileBasedContentStoreAdapter
implements ResourceLoaderAware {
    public static final String STORE_TYPE = "filesystem";
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public Context createContext(String id, String storeServerUrl, String username, String password, String rootFolderPath, boolean cacheOn, int maxAllowedItemsInCache, boolean ignoreHiddenFiles) throws StoreException, AuthenticationException {
        try {
            Resource rootFolderResource = this.resourceLoader.getResource(rootFolderPath);
            FileSystemFile rootFolder = new FileSystemFile(rootFolderResource.getFile());
            return new FileSystemContext(id, this, null, rootFolderPath, rootFolder, cacheOn, maxAllowedItemsInCache, ignoreHiddenFiles);
        }
        catch (IOException e) {
            throw new StoreException("Unable to get a File object from the specified rootFolderPath", e);
        }
    }

    @Override
    public void destroyContext(Context context) throws InvalidContextException, StoreException, AuthenticationException {
    }

    @Override
    protected File getFile(Context context, String path) throws InvalidContextException, PathNotFoundException, StoreException {
        FileSystemFile rootFolder = ((FileSystemContext)context).getRootFolder();
        if (StringUtils.isNotEmpty((String)path)) {
            FileSystemFile file = new FileSystemFile(rootFolder, path);
            if (file.getFile().exists()) {
                return file;
            }
            throw new PathNotFoundException("File " + file + " can't be found");
        }
        return rootFolder;
    }

    @Override
    protected List<File> getChildren(Context context, File dir) throws InvalidContextException, PathNotFoundException, StoreException {
        java.io.File[] listing = context.ignoreHiddenFiles() ? ((FileSystemFile)dir).getFile().listFiles(IgnoreHiddenFileFilter.INSTANCE) : ((FileSystemFile)dir).getFile().listFiles();
        if (listing != null) {
            ArrayList<File> children = new ArrayList<File>(listing.length);
            for (java.io.File file : listing) {
                children.add(new FileSystemFile(file));
            }
            return children;
        }
        return null;
    }

    private static class IgnoreHiddenFileFilter
    implements FileFilter {
        public static final IgnoreHiddenFileFilter INSTANCE = new IgnoreHiddenFileFilter();

        private IgnoreHiddenFileFilter() {
        }

        @Override
        public boolean accept(java.io.File pathname) {
            return !pathname.isHidden();
        }
    }
}

