/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import org.apache.commons.lang.StringUtils;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;

public class AddPrefixAndSuffixUrlTransformer
implements UrlTransformer {
    private String prefix;
    private String suffix;
    private boolean prefixPathSeparator = true;
    private boolean suffixPathSeparator = false;

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setAddPrefixPathSeparator(boolean addPrefixPathSeparator) {
        this.prefixPathSeparator = addPrefixPathSeparator;
    }

    public void setAddSuffixPathSeparator(boolean addSuffixPathSeparator) {
        this.suffixPathSeparator = addSuffixPathSeparator;
    }

    public void setPrefixPathSeparator(boolean prefixPathSeparator) {
        this.prefixPathSeparator = prefixPathSeparator;
    }

    public void setSuffixPathSeparator(boolean suffixPathSeparator) {
        this.suffixPathSeparator = suffixPathSeparator;
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        StringBuilder urlBuf = new StringBuilder(url);
        if (StringUtils.isNotEmpty((String)this.prefix)) {
            if (this.prefixPathSeparator && !url.startsWith("/")) {
                urlBuf.insert(0, '/');
            }
            urlBuf.insert(0, this.prefix);
        }
        if (StringUtils.isNotEmpty((String)this.suffix)) {
            if (this.suffixPathSeparator && !url.endsWith("/")) {
                urlBuf.append('/');
            }
            urlBuf.append(this.suffix);
        }
        return urlBuf.toString();
    }
}

