/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import java.util.Map;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.craftercms.core.util.HttpServletUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.util.UriTemplate;

public class ExtractRequestAttributesUrlTransformer
implements UrlTransformer {
    private UriTemplate uriTemplate;

    @Required
    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = new UriTemplate(uriTemplate);
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        if (this.uriTemplate.matches(url)) {
            Map variables = this.uriTemplate.match(url);
            for (Map.Entry entry : variables.entrySet()) {
                HttpServletUtils.setAttribute((String)entry.getKey(), entry.getValue(), 0);
            }
            url = this.uriTemplate.toString().replaceAll("\\{[^{}]+\\}", "");
            url = url.replace("//", "/");
        }
        return url;
    }
}

