/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.springframework.beans.factory.annotation.Required;

public class ReplacePatternAllUrlTransformer
implements UrlTransformer {
    private static final Log logger = LogFactory.getLog(ReplacePatternAllUrlTransformer.class);
    protected String patternToReplace;
    protected String replacement;

    @Required
    public void setPatternToReplace(String patternToReplace) {
        this.patternToReplace = patternToReplace;
    }

    @Required
    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    @Override
    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        String result = this.doReplacing(url);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation in: " + url + ", Transformation out: " + result));
        }
        return result;
    }

    protected String doReplacing(String url) {
        return url.replaceAll(this.patternToReplace, this.replacement);
    }
}

