/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.url.impl;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.craftercms.core.url.impl.AbstractCachedUrlTransformationEngine;
import org.springframework.beans.factory.annotation.Required;

public class UrlTransformationEngineImpl
extends AbstractCachedUrlTransformationEngine {
    private static final Log logger = LogFactory.getLog(UrlTransformationEngineImpl.class);
    private Map<String, UrlTransformer> transformers;

    @Required
    public void setTransformers(Map<String, UrlTransformer> transformers) {
        this.transformers = transformers;
    }

    @Override
    protected String doTransformUrl(Context context, CachingOptions cachingOptions, String transformerName, String url) throws UrlTransformationException {
        UrlTransformer transformer = this.transformers.get(transformerName);
        if (transformer == null) {
            throw new UrlTransformationException("Url transformer " + transformerName + " not found");
        }
        String result = transformer.transformUrl(context, cachingOptions, url);
        if (StringUtils.isEmpty((String)result)) {
            result = "/";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transformation in: " + url + ", Transformation out: " + result));
        }
        return result;
    }
}

