/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.core.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpServletUtils {
    public static final int SCOPE_REQUEST = 0;
    public static final int SCOPE_SESSION = 1;

    public static HttpServletRequest getCurrentRequest() throws IllegalStateException {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            return ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        throw new IllegalStateException("Current RequestAttributes isn't of type ServletRequestAttributes. Are you sure you'rerunning in a Servlet environment?");
    }

    public static Object getAttribute(String name, int scope) throws IllegalStateException {
        return RequestContextHolder.currentRequestAttributes().getAttribute(name, scope);
    }

    public static void setAttribute(String name, Object value, int scope) throws IllegalStateException {
        RequestContextHolder.currentRequestAttributes().setAttribute(name, value, scope);
    }

    public static void removeAttribute(String name, int scope) throws IllegalStateException {
        RequestContextHolder.currentRequestAttributes().removeAttribute(name, scope);
    }

    public static Cookie getCookie(String name, HttpServletRequest request) {
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isNotEmpty((Object[])cookies)) {
            for (Object cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static Map<String, Object> getParamsFromQueryString(String queryString) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)queryString)) {
            String[] params;
            for (String param : params = queryString.split("&")) {
                String[] splitParam = param.split("=");
                String paramName = splitParam[0];
                String paramValue = splitParam[1];
                if (queryParams.containsKey(paramName)) {
                    if (queryParams.get(paramName) instanceof List) {
                        ((List)queryParams.get(paramName)).add(paramValue);
                        continue;
                    }
                    List<String> paramValues = Arrays.asList((String)queryParams.get(paramName), paramValue);
                    queryParams.put(paramName, paramValues);
                    continue;
                }
                queryParams.put(paramName, paramValue);
            }
        }
        return queryParams;
    }

    public static String getQueryStringFromParams(Map<String, Object> queryParams, String charset) throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        if (MapUtils.isNotEmpty(queryParams)) {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                String paramName = URLEncoder.encode(entry.getKey(), charset);
                if (entry.getValue() instanceof List) {
                    for (String paramValue : (List)entry.getValue()) {
                        if (queryString.length() > 0) {
                            queryString.append('&');
                        }
                        paramValue = URLEncoder.encode(paramValue, charset);
                        queryString.append(paramName).append('=').append(paramValue);
                    }
                    continue;
                }
                if (queryString.length() > 0) {
                    queryString.append('&');
                }
                String paramValue = URLEncoder.encode((String)entry.getValue(), charset);
                queryString.append(paramName).append('=').append(paramValue);
            }
            queryString.insert(0, '?');
        }
        return queryString.toString();
    }

    public static Map<String, Object> createRequestParamsMap(HttpServletRequest request) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        Enumeration paramNameEnum = request.getParameterNames();
        while (paramNameEnum.hasMoreElements()) {
            String paramName = (String)paramNameEnum.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            if (paramValues.length == 1) {
                paramsMap.put(paramName, paramValues[0]);
                continue;
            }
            paramsMap.put(paramName, paramValues);
        }
        return paramsMap;
    }

    public static Map<String, Object> createRequestAttributesMap(HttpServletRequest request) {
        HashMap<String, Object> attributesMap = new HashMap<String, Object>();
        Enumeration attributeNameEnum = request.getAttributeNames();
        while (attributeNameEnum.hasMoreElements()) {
            String attributeName = (String)attributeNameEnum.nextElement();
            attributesMap.put(attributeName, request.getAttribute(attributeName));
        }
        return attributesMap;
    }

    public static Map<String, Object> createHeadersMap(HttpServletRequest request) {
        HashMap<String, Object> headersMap = new HashMap<String, Object>();
        Enumeration headerNameEnum = request.getHeaderNames();
        while (headerNameEnum.hasMoreElements()) {
            String headerName = (String)headerNameEnum.nextElement();
            ArrayList headerValues = new ArrayList();
            CollectionUtils.addAll(headerValues, (Enumeration)request.getHeaders(headerName));
            if (headerValues.size() == 1) {
                headersMap.put(headerName, headerValues.get(0));
                continue;
            }
            headersMap.put(headerName, headerValues.toArray(new String[headerValues.size()]));
        }
        return headersMap;
    }

    public static Map<String, String> createCookiesMap(HttpServletRequest request) {
        HashMap<String, String> cookiesMap = new HashMap<String, String>();
        Object[] cookies = request.getCookies();
        if (ArrayUtils.isNotEmpty((Object[])cookies)) {
            for (Cookie cookie : request.getCookies()) {
                cookiesMap.put(cookie.getName(), cookie.getValue());
            }
        }
        return cookiesMap;
    }

    public static Map<String, Object> createSessionMap(HttpServletRequest request) {
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Enumeration attributeNameEnum = session.getAttributeNames();
            while (attributeNameEnum.hasMoreElements()) {
                String attributeName = (String)attributeNameEnum.nextElement();
                sessionMap.put(attributeName, session.getAttribute(attributeName));
            }
        }
        return sessionMap;
    }
}

