/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class UrlUtils {
    public static final char URL_PARAM_DELIM = '?';
    public static final char URL_PARAM_SEPARATOR = '&';

    public static String getShortName(String longName, String containsShortNameRegex, int shortNameRegexGroup) {
        Pattern pattern = Pattern.compile(containsShortNameRegex);
        Matcher matcher = pattern.matcher(longName);
        if (matcher.matches()) {
            return matcher.group(shortNameRegexGroup);
        }
        return longName;
    }

    public static String resolveRelative(String baseUrl, String relativeUrl) throws URISyntaxException {
        if (!relativeUrl.startsWith("/")) {
            if (!(baseUrl = FilenameUtils.getFullPath((String)baseUrl)).startsWith("/")) {
                baseUrl = "/" + baseUrl;
            }
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            URI base = new URI(baseUrl);
            return base.resolve(relativeUrl).toString();
        }
        return relativeUrl;
    }

    public static final String appendUrl(String mainUrl, String urlToAppend) {
        StringBuilder joinedUrl = new StringBuilder(mainUrl);
        if (mainUrl.endsWith("/") && urlToAppend.startsWith("/")) {
            urlToAppend = StringUtils.stripStart((String)urlToAppend, (String)"/");
        } else if (!mainUrl.endsWith("/") && !urlToAppend.startsWith("/")) {
            joinedUrl.append("/");
        }
        joinedUrl.append(urlToAppend);
        return joinedUrl.toString();
    }
}

