/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.core.util.JsonUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlUtils {
    public static final String XML_ELEMENT_TEXT_JSON_KEY = "text";

    public static String selectSingleNodeValue(Node node, String xPathQuery) {
        Node resultNode = node.selectSingleNode(xPathQuery);
        if (resultNode != null) {
            return resultNode.getText();
        }
        return null;
    }

    public static String selectSingleNodeValue(Node node, String xPathQuery, Map<String, String> namespaceUris) {
        Node resultNode = XmlUtils.selectSingleNode(node, xPathQuery, namespaceUris);
        if (resultNode != null) {
            return resultNode.getText();
        }
        return null;
    }

    public static List<String> selectNodeValues(Node node, String xPathQuery) {
        List resultNodes = node.selectNodes(xPathQuery);
        if (CollectionUtils.isNotEmpty((Collection)resultNodes)) {
            ArrayList<String> resultNodeValues = new ArrayList<String>(resultNodes.size());
            for (Node resultNode : resultNodes) {
                resultNodeValues.add(resultNode.getText());
            }
            return resultNodeValues;
        }
        return Collections.emptyList();
    }

    public static List<String> selectNodeValues(Node node, String xPathQuery, Map<String, String> namespaceUris) {
        List<Node> resultNodes = XmlUtils.selectNodes(node, xPathQuery, namespaceUris);
        if (CollectionUtils.isNotEmpty(resultNodes)) {
            ArrayList<String> resultNodeValues = new ArrayList<String>(resultNodes.size());
            for (Node resultNode : resultNodes) {
                resultNodeValues.add(resultNode.getText());
            }
            return resultNodeValues;
        }
        return Collections.emptyList();
    }

    public static Node selectSingleNode(Node node, String xPathQuery, Map<String, String> namespaceUris) {
        XPath xPath = DocumentHelper.createXPath((String)xPathQuery);
        xPath.setNamespaceURIs(namespaceUris);
        return xPath.selectSingleNode((Object)node);
    }

    public static List<Node> selectNodes(Node node, String xPathQuery, Map<String, String> namespaceUris) {
        XPath xPath = DocumentHelper.createXPath((String)xPathQuery);
        xPath.setNamespaceURIs(namespaceUris);
        return xPath.selectNodes((Object)node);
    }

    public static String documentToPrettyString(Document document) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat prettyPrintFormat = OutputFormat.createPrettyPrint();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, prettyPrintFormat);
        try {
            xmlWriter.write(document);
        }
        catch (IOException e) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static JsonElement documentToJson(Document document) {
        JsonObject json = new JsonObject();
        XmlUtils.elementToJson(document.getRootElement(), json);
        return json;
    }

    private static void elementToJson(Element element, JsonObject parentJson) {
        JsonObject elementJson = null;
        if (element.attributeCount() > 0) {
            elementJson = new JsonObject();
            List attributes = element.attributes();
            for (Attribute attribute : attributes) {
                JsonUtils.setOrAccumulate(elementJson, attribute.getName(), (JsonElement)new JsonPrimitive(attribute.getValue()));
            }
        }
        if (!element.hasContent()) {
            if (elementJson == null) {
                XmlUtils.addElementTextToJson(parentJson, elementJson, element.getName(), null);
            }
        } else if (element.isTextOnly()) {
            XmlUtils.addElementTextToJson(parentJson, elementJson, element.getName(), element.getText());
        } else {
            if (elementJson == null) {
                elementJson = new JsonObject();
            }
            if (element.hasMixedContent()) {
                List<String> textContent = XmlUtils.getTextContentFromMixedContent(element);
                for (String text : textContent) {
                    XmlUtils.addElementTextToJson(parentJson, elementJson, element.getName(), text);
                }
            }
            List children = element.elements();
            for (Element child : children) {
                XmlUtils.elementToJson(child, elementJson);
            }
        }
        if (elementJson != null) {
            JsonUtils.setOrAccumulate(parentJson, element.getName(), (JsonElement)elementJson);
        }
    }

    private static void addElementTextToJson(JsonObject parentJson, JsonObject elementJson, String elementName, String text) {
        Object value = text != null ? new JsonPrimitive(text) : JsonNull.INSTANCE;
        if (elementJson != null) {
            JsonUtils.setOrAccumulate(elementJson, XML_ELEMENT_TEXT_JSON_KEY, (JsonElement)value);
        } else {
            JsonUtils.setOrAccumulate(parentJson, elementName, (JsonElement)value);
        }
    }

    private static List<String> getTextContentFromMixedContent(Element element) {
        List content = element.content();
        ArrayList<String> textContent = new ArrayList<String>();
        for (Node node : content) {
            String text;
            if (node.getNodeType() != 3 || !StringUtils.isNotBlank((String)(text = node.getText()))) continue;
            textContent.add(text);
        }
        return textContent;
    }
}

