/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.spring;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public abstract class AbstractBeanIdBasedRegistry<T>
implements BeanPostProcessor {
    private Map<String, T> registry;

    @PostConstruct
    public void init() {
        this.registry = this.createRegistry();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.getRegistryType().isAssignableFrom(bean.getClass()) && beanName.startsWith(this.getBeanNameIdPrefix())) {
            String id = beanName.substring(this.getBeanNameIdPrefix().length());
            this.register(id, bean);
        }
        return bean;
    }

    public T get(String id) {
        return this.registry.get(id);
    }

    protected void register(String id, T obj) {
        this.registry.put(id, obj);
    }

    protected abstract Class<T> getRegistryType();

    protected abstract String getBeanNameIdPrefix();

    protected abstract Map<String, T> createRegistry();
}

