/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.spring.mvc;

import com.google.gson.Gson;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.util.JsonUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

public class GsonView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/json";
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final String JSON_ANTI_HIJACKING_PREFIX = "{} &&";
    public static final String PRAGMA_HEADER_NAME = "Pragma";
    public static final String CACHE_CONTROL_HEADER_NAME = "Cache-Control";
    public static final String EXPIRES_HEADER_NAME = "Expires";
    public static final String DISABLED_CACHING_PRAGMA_HEADER_VALUE = "no-cache";
    public static final String DISABLED_CACHING_CACHE_CONTROL_HEADER_VALUE = "no-cache, no-store, max-age=0";
    public static final long DISABLED_CACHING_EXPIRES_HEADER_VALUE = 1L;
    private Gson gson = JsonUtils.getDefaultGsonBuilder().create();
    private boolean prefixJson;
    private boolean disableCaching;
    private Set<String> renderedAttributes;
    private boolean renderSingleAttributeAsRootObject;

    public GsonView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.prefixJson = prefixJson;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void setRenderedAttributes(Set<String> renderedAttributes) {
        this.renderedAttributes = renderedAttributes;
    }

    public void setRenderSingleAttributeAsRootObject(boolean renderSingleAttributeAsRootObject) {
        this.renderSingleAttributeAsRootObject = renderSingleAttributeAsRootObject;
    }

    protected void prepareResponse(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(this.getContentType());
        response.setCharacterEncoding(DEFAULT_CHARACTER_ENCODING);
        if (this.disableCaching) {
            response.addHeader(PRAGMA_HEADER_NAME, DISABLED_CACHING_PRAGMA_HEADER_VALUE);
            response.addHeader(CACHE_CONTROL_HEADER_NAME, DISABLED_CACHING_CACHE_CONTROL_HEADER_VALUE);
            response.addDateHeader(EXPIRES_HEADER_NAME, 1L);
        }
    }

    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        model = this.filterModel(model);
        PrintWriter output = response.getWriter();
        if (this.prefixJson) {
            ((Writer)output).write(JSON_ANTI_HIJACKING_PREFIX);
        }
        if (this.renderSingleAttributeAsRootObject && model.size() == 1) {
            this.gson.toJson(model.values().iterator().next(), (Appendable)output);
        } else {
            this.gson.toJson(model, (Appendable)output);
        }
    }

    protected Map<String, Object> filterModel(Map<String, Object> model) {
        HashMap<String, Object> filteredModel = new HashMap<String, Object>(model.size());
        Set<String> renderedAttributes = CollectionUtils.isNotEmpty(this.renderedAttributes) ? this.renderedAttributes : model.keySet();
        for (Map.Entry<String, Object> attribute : model.entrySet()) {
            if (attribute.getValue() instanceof BindingResult || !renderedAttributes.contains(attribute.getKey())) continue;
            filteredModel.put(attribute.getKey(), attribute.getValue());
        }
        return filteredModel;
    }
}

