/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.xml.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.craftercms.core.util.xml.NodeScanner;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.springframework.beans.factory.annotation.Required;

public class RegexNodeScanner
implements NodeScanner {
    protected Pattern[] patterns;
    protected boolean matchEntireNodeText = true;

    @Required
    public void setPatterns(Pattern ... patterns) {
        this.patterns = patterns;
    }

    public void setMatchEntireNodeText(boolean matchEntireNodeText) {
        this.matchEntireNodeText = matchEntireNodeText;
    }

    @Override
    public List<Node> scan(Document document) {
        ArrayList<Node> matchingNodes = new ArrayList<Node>();
        for (Pattern pattern : this.patterns) {
            document.accept((Visitor)new RegexMatcherVisitor(matchingNodes, pattern));
        }
        return matchingNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexNodeScanner that = (RegexNodeScanner)o;
        if (this.matchEntireNodeText != that.matchEntireNodeText) {
            return false;
        }
        return this.patterns.equals(that.patterns);
    }

    public int hashCode() {
        int result = this.patterns.hashCode();
        result = 31 * result + (this.matchEntireNodeText ? 1 : 0);
        return result;
    }

    protected class RegexMatcherVisitor
    extends VisitorSupport {
        protected List<Node> matchingNodes;
        protected Pattern pattern;

        public RegexMatcherVisitor(List<Node> matchingNodes, Pattern pattern) {
            this.matchingNodes = matchingNodes;
            this.pattern = pattern;
        }

        public void visit(Text text) {
            if (this.matchNodeText((Node)text)) {
                this.matchingNodes.add((Node)text);
            }
        }

        public void visit(CDATA cdata) {
            if (this.matchNodeText((Node)cdata)) {
                this.matchingNodes.add((Node)cdata);
            }
        }

        public void visit(Attribute attribute) {
            if (this.matchNodeText((Node)attribute)) {
                this.matchingNodes.add((Node)attribute);
            }
        }

        protected boolean matchNodeText(Node node) {
            String text = node.getText();
            Matcher matcher = this.pattern.matcher(text);
            if (RegexNodeScanner.this.matchEntireNodeText) {
                return matcher.matches();
            }
            return matcher.find();
        }
    }
}

