/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.core.util.xml.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.craftercms.core.exception.XmlException;
import org.craftercms.core.util.xml.NodeScanner;
import org.dom4j.Document;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public class XPathNodeScanner
implements NodeScanner {
    protected String[] xPathQueries;

    @Required
    public void setXPathQueries(String ... xPathQueries) {
        this.xPathQueries = xPathQueries;
    }

    @Override
    public List<Node> scan(Document document) throws XmlException {
        try {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (String xPathQuery : this.xPathQueries) {
                List queryResult = document.selectNodes(xPathQuery);
                if (!CollectionUtils.isNotEmpty((Collection)queryResult)) continue;
                nodes.addAll(queryResult);
            }
            return nodes;
        }
        catch (Exception e) {
            throw new XmlException(this.xPathQueries + " query failed", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPathNodeScanner that = (XPathNodeScanner)o;
        return this.xPathQueries.equals(that.xPathQueries);
    }

    public int hashCode() {
        return this.xPathQueries.hashCode();
    }
}

